/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.bigarray;

import hic.tools.utils.largelists.BigDoublesArray;
import hic.tools.utils.largelists.BigFloatsArray;
import hic.tools.utils.largelists.BigIntsArray;
import hic.tools.utils.original.ExpectedValueCalculation;
import javastraw.reader.datastructures.ListOfFloatArrays;

public class SparseMatrixTools {
    public static void matrixVectorMult(BigFloatsArray vector, BigDoublesArray sumVector, int x, int y, float c) {
        double counts = c;
        if (x == y) {
            counts *= 0.5;
        }
        sumVector.addTo(x, counts * (double)vector.get(y));
        sumVector.addTo(y, counts * (double)vector.get(x));
    }

    public static void matrixVectorMult(BigIntsArray vector, BigDoublesArray sumVector, int x, int y, float c) {
        double counts = c;
        if (x == y) {
            counts *= 0.5;
        }
        sumVector.addTo(x, counts * (double)vector.get(y));
        sumVector.addTo(y, counts * (double)vector.get(x));
    }

    public static void invertVector(ListOfFloatArrays newNormVector) {
        for (long k = 0L; k < newNormVector.getLength(); ++k) {
            float kVal = newNormVector.get(k);
            if (kVal > 0.0f) {
                newNormVector.set(k, 1.0f / kVal);
                continue;
            }
            newNormVector.set(k, Float.NaN);
        }
    }

    public static void populateNormedExpected(int chrIdx, ListOfFloatArrays expectedVector, ExpectedValueCalculation exp, int x, int y, float counts) {
        if (counts > 0.0f) {
            double value;
            float vx = expectedVector.get(x);
            float vy = expectedVector.get(y);
            if (vx > 0.0f && vy > 0.0f && (value = (double)(counts / (vx * vy))) > 0.0) {
                exp.addDistance(chrIdx, x, y, value);
            }
        }
    }

    public static void sumRawAndNorm(double[] normSum, double[] sum, int x, int y, float counts, ListOfFloatArrays newNormVector) {
        double valX = newNormVector.get(x);
        double valY = newNormVector.get(y);
        if (valX > 0.0 && valY > 0.0) {
            double normalizedValue = (double)counts / (valX * valY);
            normSum[0] = normSum[0] + normalizedValue;
            sum[0] = sum[0] + (double)counts;
            if (x != y) {
                normSum[0] = normSum[0] + normalizedValue;
                sum[0] = sum[0] + (double)counts;
            }
        }
    }

    public static void sumScaleFactor(ListOfFloatArrays norm, double[] mSum, double[] nSum, int x, int y, float value) {
        double valX = norm.get(x);
        double valY = norm.get(y);
        if (valX > 0.0 && valY > 0.0) {
            if (x == y) {
                nSum[0] = nSum[0] + (double)value / (valX * valY);
                mSum[0] = mSum[0] + (double)value;
            } else {
                nSum[0] = nSum[0] + (double)(2.0f * value) / (valX * valY);
                mSum[0] = mSum[0] + (double)(2.0f * value);
            }
        }
    }

    public static void updateRowSums(ListOfFloatArrays sums, int x, int y, float value) {
        sums.addTo(x, value);
        if (x != y) {
            sums.addTo(y, value);
        }
    }
}

