/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.bigarray;

import com.google.common.util.concurrent.AtomicDouble;
import hic.HiCGlobals;
import hic.tools.utils.bigarray.BigContactList;
import hic.tools.utils.bigarray.SparseMatrixTools;
import hic.tools.utils.largelists.BigDoublesArray;
import hic.tools.utils.largelists.BigFloatsArray;
import hic.tools.utils.largelists.BigIntsArray;
import hic.tools.utils.localtemps.BinRecordsReader;
import hic.tools.utils.localtemps.BinRecordsWriter;
import hic.tools.utils.original.ExpectedValueCalculation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javastraw.reader.Dataset;
import javastraw.reader.basics.ChromosomeHandler;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.datastructures.ListOfFloatArrays;
import javastraw.reader.datastructures.ListOfIntArrays;
import javastraw.reader.type.HiCZoom;
import javastraw.tools.ParallelizationTools;

public class LocallySavedContacts
implements BigContactList {
    public static final String INTRA = "intra.";
    public static final String INTER = "inter.";
    public static final String GENERIC = "contacts.";
    private final List<String> filenames = Collections.synchronizedList(new ArrayList());
    private final long matrixSize;

    public LocallySavedContacts(Iterator<ContactRecord> directIterator, int bufferSize, long matrixSize) {
        this.matrixSize = matrixSize;
        try {
            BinRecordsWriter.saveAllContacts(directIterator, bufferSize, this.filenames, GENERIC);
        }
        catch (Exception e) {
            System.err.println("ERROR: Unable to save data locally");
            e.printStackTrace();
            System.exit(20);
        }
    }

    public LocallySavedContacts(Dataset ds, ChromosomeHandler handler, HiCZoom zoom, boolean includeIntra, int bufferSize, long matrixSize) {
        this.matrixSize = matrixSize;
        try {
            BinRecordsWriter.saveAllGWContacts(ds, handler, zoom, includeIntra, bufferSize, this.filenames, INTRA, INTER);
        }
        catch (Exception e) {
            System.err.println("ERROR: Unable to save data locally");
            e.printStackTrace();
            System.exit(20);
        }
    }

    @Override
    public void clear() {
        for (String filename : this.filenames) {
            File file = new File(filename);
            file.delete();
        }
        this.filenames.clear();
    }

    @Override
    public void clearIntraAndShiftInter() {
        ArrayList<String> toDelete = new ArrayList<String>();
        for (String filename : this.filenames) {
            if (!filename.contains(INTRA)) continue;
            File file = new File(filename);
            file.delete();
            toDelete.add(filename);
        }
        this.filenames.removeAll(toDelete);
    }

    @Override
    public long getMatrixSize() {
        return this.matrixSize;
    }

    private int getNumThreads() {
        return Math.min(HiCGlobals.normThreads, this.filenames.size());
    }

    @Override
    public BigFloatsArray parSparseMultiplyAcrossLists(BigFloatsArray vector, long vectorLength) {
        BigDoublesArray totalSumVector = new BigDoublesArray(vectorLength);
        AtomicInteger index = new AtomicInteger(0);
        ParallelizationTools.launchParallelizedCode(this.getNumThreads(), () -> {
            int sIndx = index.getAndIncrement();
            BigDoublesArray sumVector = new BigDoublesArray(vectorLength);
            while (sIndx < this.filenames.size()) {
                try {
                    BinRecordsReader reader = new BinRecordsReader(this.filenames.get(sIndx));
                    while (reader.hasNext()) {
                        ContactRecord record = reader.next();
                        SparseMatrixTools.matrixVectorMult(vector, sumVector, record.getBinX(), record.getBinY(), record.getCounts());
                    }
                    reader.close();
                }
                catch (IOException e) {
                    System.err.println("ERROR: unable to read file (" + this.filenames.get(sIndx) + "): " + e.getMessage());
                    e.printStackTrace();
                    System.exit(9);
                }
                sIndx = index.getAndIncrement();
            }
            BigDoublesArray bigDoublesArray = totalSumVector;
            synchronized (bigDoublesArray) {
                totalSumVector.addValuesFrom(sumVector);
            }
        });
        return totalSumVector.convertToFloats();
    }

    @Override
    public BigFloatsArray parSparseMultiplyAcrossLists(BigIntsArray vector, long vectorLength) {
        BigDoublesArray totalSumVector = new BigDoublesArray(vectorLength);
        AtomicInteger index = new AtomicInteger(0);
        ParallelizationTools.launchParallelizedCode(this.getNumThreads(), () -> {
            int sIndx = index.getAndIncrement();
            BigDoublesArray sumVector = new BigDoublesArray(vectorLength);
            while (sIndx < this.filenames.size()) {
                try {
                    BinRecordsReader reader = new BinRecordsReader(this.filenames.get(sIndx));
                    while (reader.hasNext()) {
                        ContactRecord record = reader.next();
                        SparseMatrixTools.matrixVectorMult(vector, sumVector, record.getBinX(), record.getBinY(), record.getCounts());
                    }
                    reader.close();
                }
                catch (IOException e) {
                    System.err.println("ERROR: unable to read file (" + this.filenames.get(sIndx) + "): " + e.getMessage());
                    e.printStackTrace();
                    System.exit(10);
                }
                sIndx = index.getAndIncrement();
            }
            BigDoublesArray bigDoublesArray = totalSumVector;
            synchronized (bigDoublesArray) {
                totalSumVector.addValuesFrom(sumVector);
            }
        });
        return totalSumVector.convertToFloats();
    }

    @Override
    public ListOfFloatArrays getRowSums() {
        ListOfFloatArrays totalRowSums = new ListOfFloatArrays(this.matrixSize, 0.0f);
        AtomicInteger index = new AtomicInteger(0);
        ParallelizationTools.launchParallelizedCode(this.getNumThreads(), () -> {
            int sIndx = index.getAndIncrement();
            ListOfFloatArrays sums = new ListOfFloatArrays(this.matrixSize);
            while (sIndx < this.filenames.size()) {
                try {
                    BinRecordsReader reader = new BinRecordsReader(this.filenames.get(sIndx));
                    while (reader.hasNext()) {
                        ContactRecord record = reader.next();
                        SparseMatrixTools.updateRowSums(sums, record.getBinX(), record.getBinY(), record.getCounts());
                    }
                    reader.close();
                }
                catch (IOException e) {
                    System.err.println("ERROR: unable to read file (" + this.filenames.get(sIndx) + "): " + e.getMessage());
                    e.printStackTrace();
                    System.exit(11);
                }
                sIndx = index.getAndIncrement();
            }
            ListOfFloatArrays listOfFloatArrays = totalRowSums;
            synchronized (listOfFloatArrays) {
                totalRowSums.addValuesFrom(sums);
            }
        });
        return totalRowSums;
    }

    @Override
    public double[] getNormMatrixSumFactor(ListOfFloatArrays norm) {
        AtomicDouble matrixSum = new AtomicDouble(0.0);
        AtomicDouble normSum = new AtomicDouble(0.0);
        AtomicInteger index = new AtomicInteger(0);
        ParallelizationTools.launchParallelizedCode(this.getNumThreads(), () -> {
            int sIndx = index.getAndIncrement();
            double[] mSum = new double[1];
            double[] nSum = new double[1];
            while (sIndx < this.filenames.size()) {
                try {
                    BinRecordsReader reader = new BinRecordsReader(this.filenames.get(sIndx));
                    while (reader.hasNext()) {
                        ContactRecord record = reader.next();
                        int x = record.getBinX();
                        int y = record.getBinY();
                        float value = record.getCounts();
                        SparseMatrixTools.sumScaleFactor(norm, mSum, nSum, x, y, value);
                    }
                    reader.close();
                }
                catch (IOException e) {
                    System.err.println("ERROR: unable to read file (" + this.filenames.get(sIndx) + "): " + e.getMessage());
                    e.printStackTrace();
                    System.exit(12);
                }
                sIndx = index.getAndIncrement();
            }
            AtomicDouble atomicDouble = matrixSum;
            synchronized (atomicDouble) {
                matrixSum.addAndGet(mSum[0]);
                normSum.addAndGet(nSum[0]);
            }
        });
        return new double[]{normSum.get(), matrixSum.get()};
    }

    @Override
    public ListOfFloatArrays normalizeVectorByScaleFactor(ListOfFloatArrays newNormVector) {
        SparseMatrixTools.invertVector(newNormVector);
        AtomicDouble normalizedSumTotal = new AtomicDouble(0.0);
        AtomicDouble sumTotal = new AtomicDouble(0.0);
        AtomicInteger index = new AtomicInteger(0);
        ParallelizationTools.launchParallelizedCode(this.getNumThreads(), () -> {
            int sIndx = index.getAndIncrement();
            double[] normSum = new double[1];
            double[] sum = new double[1];
            while (sIndx < this.filenames.size()) {
                try {
                    BinRecordsReader reader = new BinRecordsReader(this.filenames.get(sIndx));
                    while (reader.hasNext()) {
                        ContactRecord record = reader.next();
                        int x = record.getBinX();
                        int y = record.getBinY();
                        float counts = record.getCounts();
                        SparseMatrixTools.sumRawAndNorm(normSum, sum, x, y, counts, newNormVector);
                    }
                    reader.close();
                }
                catch (IOException e) {
                    System.err.println("ERROR: unable to read file (" + this.filenames.get(sIndx) + "): " + e.getMessage());
                    e.printStackTrace();
                    System.exit(13);
                }
                sIndx = index.getAndIncrement();
            }
            AtomicDouble atomicDouble = normalizedSumTotal;
            synchronized (atomicDouble) {
                normalizedSumTotal.addAndGet(normSum[0]);
                sumTotal.addAndGet(sum[0]);
            }
        });
        double scaleFactor = Math.sqrt(normalizedSumTotal.get() / sumTotal.get());
        newNormVector.multiplyEverythingBy(scaleFactor);
        return newNormVector;
    }

    @Override
    public ListOfIntArrays getNumNonZeroInRows() {
        ListOfIntArrays numNonZeros = new ListOfIntArrays(this.matrixSize);
        AtomicInteger index = new AtomicInteger(0);
        ParallelizationTools.launchParallelizedCode(this.getNumThreads(), () -> {
            int sIndx = index.getAndIncrement();
            ListOfIntArrays nonZeros = new ListOfIntArrays(this.matrixSize);
            while (sIndx < this.filenames.size()) {
                try {
                    BinRecordsReader reader = new BinRecordsReader(this.filenames.get(sIndx));
                    while (reader.hasNext()) {
                        ContactRecord record = reader.next();
                        nonZeros.addTo(record.getBinX(), 1);
                        if (record.getBinX() == record.getBinY()) continue;
                        nonZeros.addTo(record.getBinY(), 1);
                    }
                    reader.close();
                }
                catch (IOException e) {
                    System.err.println("ERROR: unable to read file (" + this.filenames.get(sIndx) + "): " + e.getMessage());
                    e.printStackTrace();
                    System.exit(14);
                }
                sIndx = index.getAndIncrement();
            }
            ListOfIntArrays listOfIntArrays = numNonZeros;
            synchronized (listOfIntArrays) {
                numNonZeros.addValuesFrom(nonZeros);
            }
        });
        return numNonZeros;
    }

    @Override
    public void updateGenomeWideExpected(int chrIdx, ListOfFloatArrays expectedVector, ExpectedValueCalculation exp) {
        for (String filename : this.filenames) {
            try {
                BinRecordsReader reader = new BinRecordsReader(filename);
                while (reader.hasNext()) {
                    ContactRecord record = reader.next();
                    int x = record.getBinX();
                    int y = record.getBinY();
                    float counts = record.getCounts();
                    SparseMatrixTools.populateNormedExpected(chrIdx, expectedVector, exp, x, y, counts);
                }
                reader.close();
            }
            catch (IOException e) {
                System.err.println("ERROR: unable to read file (" + filename + "): " + e.getMessage());
                e.printStackTrace();
                System.exit(15);
            }
        }
    }
}

