/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.bigarray;

import hic.tools.utils.bigarray.BigContactArray;
import hic.tools.utils.bigarray.BigContactArrayCreator;
import hic.tools.utils.bigarray.BigGWContactArray;
import hic.tools.utils.bigarray.LocallySavedContacts;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javastraw.reader.Dataset;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.basics.ChromosomeHandler;
import javastraw.reader.iterators.GenomeWideIterator;
import javastraw.reader.type.HiCZoom;

public class BigGWContactArrayCreator {
    public static LocallySavedContacts createLocalVersionWholeGenome(Dataset dataset, ChromosomeHandler handler, HiCZoom zoom, boolean includeIntra) {
        int limit = 100000000;
        long matrixSize = BigGWContactArrayCreator.calculateGWSize(handler, zoom.getBinSize());
        return new LocallySavedContacts(dataset, handler, zoom, includeIntra, limit, matrixSize);
    }

    public static BigGWContactArray createForWholeGenome(Dataset dataset, ChromosomeHandler handler, HiCZoom zoom, boolean includeIntra) {
        int limit = 10000000;
        if (includeIntra) {
            limit = 50000000;
        }
        long matrixSize = BigGWContactArrayCreator.calculateGWSize(handler, zoom.getBinSize());
        BigContactArray[] bas = BigGWContactArrayCreator.parLoadInterAndIntraGWData(dataset, handler, zoom, includeIntra, limit, matrixSize);
        BigGWContactArray array = new BigGWContactArray(matrixSize);
        array.addAllSubLists(bas[0]);
        array.addAllSubListsToInterBackup(bas[0]);
        if (bas[1] != null) {
            array.addAllSubLists(bas[1]);
        }
        bas = null;
        return array;
    }

    private static BigContactArray[] parLoadInterAndIntraGWData(Dataset dataset, ChromosomeHandler handler, HiCZoom zoom, boolean includeIntra, int limit, long matrixSize) {
        Object[] bas = new BigContactArray[2];
        Arrays.fill(bas, null);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        Runnable worker = () -> BigGWContactArrayCreator.lambda$parLoadInterAndIntraGWData$0((BigContactArray[])bas, dataset, handler, zoom, limit, matrixSize);
        executor.execute(worker);
        Runnable worker2 = () -> BigGWContactArrayCreator.lambda$parLoadInterAndIntraGWData$1(includeIntra, (BigContactArray[])bas, dataset, handler, zoom, limit, matrixSize);
        executor.execute(worker2);
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        return bas;
    }

    public static long calculateGWSize(ChromosomeHandler handler, int resolution) {
        long totalSize = 0L;
        for (Chromosome c1 : handler.getChromosomeArrayWithoutAllByAll()) {
            totalSize += c1.getLength() / (long)resolution + 1L;
        }
        return totalSize;
    }

    private static /* synthetic */ void lambda$parLoadInterAndIntraGWData$1(boolean includeIntra, BigContactArray[] bas, Dataset dataset, ChromosomeHandler handler, HiCZoom zoom, int limit, long matrixSize) {
        if (includeIntra) {
            bas[1] = BigContactArrayCreator.populateBigArrayFromSingleIterator(new GenomeWideIterator(dataset, handler, zoom, true, false), limit, matrixSize);
        }
    }

    private static /* synthetic */ void lambda$parLoadInterAndIntraGWData$0(BigContactArray[] bas, Dataset dataset, ChromosomeHandler handler, HiCZoom zoom, int limit, long matrixSize) {
        bas[0] = BigContactArrayCreator.populateBigArrayFromSingleIterator(new GenomeWideIterator(dataset, handler, zoom, false, true), limit, matrixSize);
    }
}

