/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.bigarray;

import hic.tools.utils.bigarray.BigContactArray;
import hic.tools.utils.bigarray.BigContactList;
import hic.tools.utils.bigarray.LocallySavedContacts;
import java.util.Iterator;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.mzd.MatrixZoomData;

public class BigContactArrayCreator {
    public static BigContactArray createFromZD(MatrixZoomData zd) {
        return BigContactArrayCreator.populateBigArrayFromSingleIterator(zd.getDirectIterator(), 10000000, zd.getMatrixSize());
    }

    public static BigContactList createLocalVersionFromZD(MatrixZoomData zd) {
        return new LocallySavedContacts(zd.getDirectIterator(), 10000000, zd.getMatrixSize());
    }

    public static BigContactArray populateBigArrayFromSingleIterator(Iterator<ContactRecord> iterator2, int limit, long matrixSize) {
        BigContactArray allRecords = new BigContactArray(matrixSize);
        int[] x = new int[limit];
        int[] y = new int[limit];
        float[] c = new float[limit];
        int counter = 0;
        while (iterator2.hasNext()) {
            ContactRecord cr = iterator2.next();
            x[counter] = cr.getBinX();
            y[counter] = cr.getBinY();
            c[counter] = cr.getCounts();
            if (++counter < limit) continue;
            allRecords.addSubList(x, y, c);
            x = new int[limit];
            y = new int[limit];
            c = new float[limit];
            counter = 0;
        }
        if (counter > 0) {
            allRecords.addSubList(x, y, c, counter);
        }
        return allRecords;
    }
}

