/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.bigarray;

import com.google.common.util.concurrent.AtomicDouble;
import hic.HiCGlobals;
import hic.tools.utils.bigarray.BigContactList;
import hic.tools.utils.bigarray.SparseMatrixTools;
import hic.tools.utils.largelists.BigDoublesArray;
import hic.tools.utils.largelists.BigFloatsArray;
import hic.tools.utils.largelists.BigIntsArray;
import hic.tools.utils.original.ExpectedValueCalculation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javastraw.reader.datastructures.ListOfFloatArrays;
import javastraw.reader.datastructures.ListOfIntArrays;
import javastraw.tools.ParallelizationTools;

public class BigContactArray
implements BigContactList {
    protected final List<int[]> binXs = new ArrayList<int[]>();
    protected final List<int[]> binYs = new ArrayList<int[]>();
    protected final List<float[]> binVals = new ArrayList<float[]>();
    private final long matrixSize;

    public BigContactArray(long matrixSize) {
        this.matrixSize = matrixSize;
    }

    public void addSubList(int[] x, int[] y, float[] c) {
        this.binXs.add(x);
        this.binYs.add(y);
        this.binVals.add(c);
    }

    public void addSubList(int[] x, int[] y, float[] c, int counter) {
        int[] x2 = new int[counter];
        int[] y2 = new int[counter];
        float[] c2 = new float[counter];
        System.arraycopy(x, 0, x2, 0, counter);
        System.arraycopy(y, 0, y2, 0, counter);
        System.arraycopy(c, 0, c2, 0, counter);
        this.addSubList(x2, y2, c2);
    }

    public void addAllSubLists(BigContactArray other) {
        this.binXs.addAll(other.binXs);
        this.binYs.addAll(other.binYs);
        this.binVals.addAll(other.binVals);
    }

    @Override
    public void clear() {
        this.binXs.clear();
        this.binYs.clear();
        this.binVals.clear();
    }

    private int getNumThreads() {
        return Math.min(HiCGlobals.normThreads, this.binXs.size());
    }

    @Override
    public BigFloatsArray parSparseMultiplyAcrossLists(BigFloatsArray vector, long vectorLength) {
        BigDoublesArray totalSumVector = new BigDoublesArray(vectorLength);
        AtomicInteger index = new AtomicInteger(0);
        ParallelizationTools.launchParallelizedCode(this.getNumThreads(), () -> {
            int sIndx = index.getAndIncrement();
            BigDoublesArray sumVector = new BigDoublesArray(vectorLength);
            while (sIndx < this.binXs.size()) {
                int[] subBinXs = this.binXs.get(sIndx);
                int[] subBinYs = this.binYs.get(sIndx);
                float[] subBinVals = this.binVals.get(sIndx);
                for (int z = 0; z < subBinXs.length; ++z) {
                    SparseMatrixTools.matrixVectorMult(vector, sumVector, subBinXs[z], subBinYs[z], subBinVals[z]);
                }
                sIndx = index.getAndIncrement();
            }
            BigDoublesArray bigDoublesArray = totalSumVector;
            synchronized (bigDoublesArray) {
                totalSumVector.addValuesFrom(sumVector);
            }
        });
        return totalSumVector.convertToFloats();
    }

    @Override
    public void clearIntraAndShiftInter() {
    }

    @Override
    public BigFloatsArray parSparseMultiplyAcrossLists(BigIntsArray vector, long vectorLength) {
        BigDoublesArray totalSumVector = new BigDoublesArray(vectorLength);
        AtomicInteger index = new AtomicInteger(0);
        ParallelizationTools.launchParallelizedCode(this.getNumThreads(), () -> {
            int sIndx = index.getAndIncrement();
            BigDoublesArray sumVector = new BigDoublesArray(vectorLength);
            while (sIndx < this.binXs.size()) {
                int[] subBinXs = this.binXs.get(sIndx);
                int[] subBinYs = this.binYs.get(sIndx);
                float[] subBinVals = this.binVals.get(sIndx);
                for (int z = 0; z < subBinXs.length; ++z) {
                    SparseMatrixTools.matrixVectorMult(vector, sumVector, subBinXs[z], subBinYs[z], subBinVals[z]);
                }
                sIndx = index.getAndIncrement();
            }
            BigDoublesArray bigDoublesArray = totalSumVector;
            synchronized (bigDoublesArray) {
                totalSumVector.addValuesFrom(sumVector);
            }
        });
        return totalSumVector.convertToFloats();
    }

    @Override
    public ListOfFloatArrays getRowSums() {
        ListOfFloatArrays totalRowSums = new ListOfFloatArrays(this.matrixSize, 0.0f);
        AtomicInteger index = new AtomicInteger(0);
        ParallelizationTools.launchParallelizedCode(this.getNumThreads(), () -> {
            int sIndx = index.getAndIncrement();
            ListOfFloatArrays sums = new ListOfFloatArrays(this.matrixSize);
            while (sIndx < this.binXs.size()) {
                int[] subBinXs = this.binXs.get(sIndx);
                int[] subBinYs = this.binYs.get(sIndx);
                float[] subBinVals = this.binVals.get(sIndx);
                for (int z = 0; z < subBinXs.length; ++z) {
                    int x = subBinXs[z];
                    int y = subBinYs[z];
                    float value = subBinVals[z];
                    SparseMatrixTools.updateRowSums(sums, x, y, value);
                }
                sIndx = index.getAndIncrement();
            }
            ListOfFloatArrays listOfFloatArrays = totalRowSums;
            synchronized (listOfFloatArrays) {
                totalRowSums.addValuesFrom(sums);
            }
        });
        return totalRowSums;
    }

    @Override
    public double[] getNormMatrixSumFactor(ListOfFloatArrays norm) {
        AtomicDouble matrixSum = new AtomicDouble(0.0);
        AtomicDouble normSum = new AtomicDouble(0.0);
        AtomicInteger index = new AtomicInteger(0);
        ParallelizationTools.launchParallelizedCode(this.getNumThreads(), () -> {
            int sIndx = index.getAndIncrement();
            double[] mSum = new double[1];
            double[] nSum = new double[1];
            while (sIndx < this.binXs.size()) {
                int[] subBinXs = this.binXs.get(sIndx);
                int[] subBinYs = this.binYs.get(sIndx);
                float[] subBinVals = this.binVals.get(sIndx);
                for (int z = 0; z < subBinXs.length; ++z) {
                    int x = subBinXs[z];
                    int y = subBinYs[z];
                    float value = subBinVals[z];
                    SparseMatrixTools.sumScaleFactor(norm, mSum, nSum, x, y, value);
                }
                sIndx = index.getAndIncrement();
            }
            AtomicDouble atomicDouble = matrixSum;
            synchronized (atomicDouble) {
                matrixSum.addAndGet(mSum[0]);
                normSum.addAndGet(nSum[0]);
            }
        });
        return new double[]{normSum.get(), matrixSum.get()};
    }

    @Override
    public long getMatrixSize() {
        return this.matrixSize;
    }

    @Override
    public ListOfFloatArrays normalizeVectorByScaleFactor(ListOfFloatArrays newNormVector) {
        SparseMatrixTools.invertVector(newNormVector);
        AtomicDouble normalizedSumTotal = new AtomicDouble(0.0);
        AtomicDouble sumTotal = new AtomicDouble(0.0);
        AtomicInteger index = new AtomicInteger(0);
        ParallelizationTools.launchParallelizedCode(this.getNumThreads(), () -> {
            int sIndx = index.getAndIncrement();
            double[] normSum = new double[1];
            double[] sum = new double[1];
            while (sIndx < this.binXs.size()) {
                int[] subBinXs = this.binXs.get(sIndx);
                int[] subBinYs = this.binYs.get(sIndx);
                float[] subBinVals = this.binVals.get(sIndx);
                for (int z = 0; z < subBinXs.length; ++z) {
                    int x = subBinXs[z];
                    int y = subBinYs[z];
                    float counts = subBinVals[z];
                    SparseMatrixTools.sumRawAndNorm(normSum, sum, x, y, counts, newNormVector);
                }
                sIndx = index.getAndIncrement();
            }
            AtomicDouble atomicDouble = normalizedSumTotal;
            synchronized (atomicDouble) {
                normalizedSumTotal.addAndGet(normSum[0]);
                sumTotal.addAndGet(sum[0]);
            }
        });
        double scaleFactor = Math.sqrt(normalizedSumTotal.get() / sumTotal.get());
        newNormVector.multiplyEverythingBy(scaleFactor);
        return newNormVector;
    }

    @Override
    public ListOfIntArrays getNumNonZeroInRows() {
        ListOfIntArrays numNonZeros = new ListOfIntArrays(this.matrixSize);
        AtomicInteger index = new AtomicInteger(0);
        ParallelizationTools.launchParallelizedCode(this.getNumThreads(), () -> {
            int sIndx = index.getAndIncrement();
            ListOfIntArrays nonZeros = new ListOfIntArrays(this.matrixSize);
            while (sIndx < this.binXs.size()) {
                int[] subBinXs = this.binXs.get(sIndx);
                int[] subBinYs = this.binYs.get(sIndx);
                for (int z = 0; z < subBinXs.length; ++z) {
                    int x = subBinXs[z];
                    int y = subBinYs[z];
                    nonZeros.addTo(x, 1);
                    if (x == y) continue;
                    nonZeros.addTo(y, 1);
                }
                sIndx = index.getAndIncrement();
            }
            ListOfIntArrays listOfIntArrays = numNonZeros;
            synchronized (listOfIntArrays) {
                numNonZeros.addValuesFrom(nonZeros);
            }
        });
        return numNonZeros;
    }

    @Override
    public void updateGenomeWideExpected(int chrIdx, ListOfFloatArrays vector, ExpectedValueCalculation exp) {
        for (int sIndx = 0; sIndx < this.binXs.size(); ++sIndx) {
            int[] subBinXs = this.binXs.get(sIndx);
            int[] subBinYs = this.binYs.get(sIndx);
            float[] subBinVals = this.binVals.get(sIndx);
            for (int z = 0; z < subBinXs.length; ++z) {
                int x = subBinXs[z];
                int y = subBinYs[z];
                float counts = subBinVals[z];
                SparseMatrixTools.populateNormedExpected(chrIdx, vector, exp, x, y, counts);
            }
        }
    }
}

