/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils;

import hic.HiCGlobals;
import hic.tools.utils.bigarray.BigContactArray;
import hic.tools.utils.bigarray.BigContactArrayCreator;
import hic.tools.utils.bigarray.BigContactList;
import hic.tools.utils.largelists.BigFloatsArray;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import javastraw.reader.Dataset;
import javastraw.reader.DatasetReaderV2;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.datastructures.ListOfFloatArrays;
import javastraw.reader.mzd.Matrix;
import javastraw.reader.mzd.MatrixZoomData;
import javastraw.reader.type.HiCZoom;

public class SpeedTests {
    public static void testRowSums() throws IOException {
        String path = "/Users/muhammad/Desktop/hicfiles/copy_tmp_chr10_subsample0.25.hic";
        DatasetReaderV2 reader = new DatasetReaderV2(path, false, false);
        Dataset ds = reader.read();
        Chromosome chr10 = ds.getChromosomeHandler().getChromosomeFromName("chr10");
        Matrix matrix = ds.getMatrix(chr10, chr10, 50);
        MatrixZoomData zd = matrix.getZoomData(new HiCZoom(50));
        HiCGlobals.normThreads = 10;
        double[] timeTotals = new double[3];
        for (int i = 0; i < 4; ++i) {
            ListOfFloatArrays f0 = SpeedTests.test0(zd, timeTotals);
            System.gc();
            ListOfFloatArrays f1 = SpeedTests.test1(zd, timeTotals);
            System.gc();
            ListOfFloatArrays f2 = SpeedTests.test2(zd, timeTotals);
            System.gc();
            SpeedTests.assertAreEqual(f0, f1, "f0_vs_f1");
            SpeedTests.assertAreEqual(f0, f2, "f0_vs_f2");
        }
        System.out.println(Arrays.toString(timeTotals));
    }

    private static ListOfFloatArrays test0(MatrixZoomData zd, double[] timeTotals) {
        long r0 = System.nanoTime();
        ListOfFloatArrays f1 = SpeedTests.testOnIterator(zd);
        long r1 = System.nanoTime();
        double time = (double)(r1 - r0) * 1.0E-9;
        timeTotals[0] = timeTotals[0] + time;
        System.err.println("\nTest 0: " + time + " seconds");
        return f1;
    }

    private static ListOfFloatArrays testOnIterator(MatrixZoomData zd) {
        ListOfFloatArrays sums = new ListOfFloatArrays(zd.getMatrixSize());
        Iterator<ContactRecord> iterator2 = zd.getDirectIterator();
        while (iterator2.hasNext()) {
            ContactRecord record = iterator2.next();
            int x = record.getBinX();
            int y = record.getBinY();
            float value = record.getCounts();
            sums.addTo(x, value);
            if (x == y) continue;
            sums.addTo(y, value);
        }
        return sums;
    }

    private static ListOfFloatArrays test1(MatrixZoomData zd, double[] timeTotals) {
        BigContactArray ba = BigContactArrayCreator.createFromZD(zd);
        long r0 = System.nanoTime();
        ListOfFloatArrays f1 = ba.getRowSums();
        long r1 = System.nanoTime();
        double time = (double)(r1 - r0) * 1.0E-9;
        timeTotals[1] = timeTotals[1] + time;
        System.err.println("\nTest 1: " + time + " seconds");
        return f1;
    }

    private static ListOfFloatArrays test2(MatrixZoomData zd, double[] timeTotals) {
        BigContactList ba = BigContactArrayCreator.createLocalVersionFromZD(zd);
        long r0 = System.nanoTime();
        ListOfFloatArrays f1 = ba.getRowSums();
        long r1 = System.nanoTime();
        double time = (double)(r1 - r0) * 1.0E-9;
        timeTotals[2] = timeTotals[2] + time;
        System.err.println("\nTest 2: " + time + " seconds");
        return f1;
    }

    public static void assertAreEqual(ListOfFloatArrays data1, ListOfFloatArrays data2, String description) {
        double magnitude = 0.0;
        double absError = 0.0;
        try {
            if (data1.getLength() != data2.getLength()) {
                System.err.println("Vector length mismatch: " + data1.getLength() + " vs " + data2.getLength() + " " + description);
            }
            long n = Math.min(data1.getLength(), data2.getLength());
            double magnitude1 = 0.0;
            double magnitude2 = 0.0;
            long numVals = 0L;
            for (long q = 0L; q < n; ++q) {
                double err = Math.abs(data1.get(q) - data2.get(q));
                if (!Double.isNaN(data1.get(q))) {
                    magnitude1 += (double)(data1.get(q) * data1.get(q));
                }
                if (!Double.isNaN(data2.get(q))) {
                    magnitude2 += (double)(data2.get(q) * data2.get(q));
                }
                if (Double.isNaN(err)) continue;
                magnitude += (double)(data1.get(q) * data2.get(q));
                absError += err;
                ++numVals;
            }
            magnitude = Math.sqrt(magnitude);
            magnitude1 = Math.sqrt(magnitude1);
            magnitude2 = Math.sqrt(magnitude2);
            if (numVals > 0L) {
                absError /= (double)numVals;
            }
            System.err.println("Vector mean error: (" + absError + ") / " + magnitude + " / " + magnitude1 + " / " + magnitude2 + " / " + description);
        }
        catch (Exception e) {
            System.exit(26);
        }
    }

    public static void testDataStructure() {
        Random generator = new Random(0L);
        double sum = 0.0;
        long len = 4000000000L;
        ListOfFloatArrays values2 = new ListOfFloatArrays(len);
        long time0 = System.nanoTime();
        for (long k = 0L; k < len; ++k) {
            float val = generator.nextFloat();
            values2.addTo(k, val);
            sum += (double)val;
        }
        long time1 = System.nanoTime();
        System.out.println("Loading time " + (time1 - time0));
        double sum2 = 0.0;
        long actualLen = 0L;
        time0 = System.nanoTime();
        for (float[] vals : values2.getValues()) {
            for (float val : vals) {
                sum2 += (double)val;
                ++actualLen;
            }
        }
        time1 = System.nanoTime();
        System.out.println("Reading time " + (time1 - time0));
        System.out.println("Intended Len " + len);
        System.out.println("Supposed Len " + values2.getLength());
        System.out.println("Actual Len " + actualLen);
        System.out.println("Intended Sum " + sum);
        System.out.println("Actual Sum " + sum2);
    }

    public static void testDataStructure2() {
        Random generator = new Random(0L);
        double sum = 0.0;
        long len = 4000000000L;
        BigFloatsArray values2 = new BigFloatsArray(len);
        long time0 = System.nanoTime();
        for (long k = 0L; k < len; ++k) {
            float val = generator.nextFloat();
            values2.set(k, val);
            sum += (double)val;
        }
        long time1 = System.nanoTime();
        System.out.println("Loading time " + (time1 - time0));
        double sum2 = 0.0;
        long actualLen = 0L;
        time0 = System.nanoTime();
        for (float[] vals : values2.getValues()) {
            for (float val : vals) {
                sum2 += (double)val;
                ++actualLen;
            }
        }
        time1 = System.nanoTime();
        System.out.println("Reading time " + (time1 - time0));
        System.out.println("Intended Len " + len);
        System.out.println("Supposed Len " + values2.getLength());
        System.out.println("Actual Len " + actualLen);
        System.out.println("Intended Sum " + sum);
        System.out.println("Actual Sum " + sum2);
    }
}

