/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.clt.old;

import hic.HiCGlobals;
import hic.tools.clt.CommandLineParser;
import hic.tools.clt.JuiceboxCLT;
import hic.tools.utils.bigarray.BigContactList;
import hic.tools.utils.norm.IntraNorms;
import hic.tools.utils.norm.NormalizationCalculations;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import javastraw.reader.Dataset;
import javastraw.reader.DatasetReaderV2;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.datastructures.ListOfFloatArrays;
import javastraw.reader.type.HiCZoom;

public class TestNorm
extends JuiceboxCLT {
    private final String norm = "SCALE";
    private int resolution = 1000;
    private String file;
    private String name;
    private String output;

    public TestNorm() {
        super(TestNorm.getBasicUsage());
    }

    public static String getBasicUsage() {
        return "testNorm [--threads number] <input.hic> <chromosome> <resolution> <output>";
    }

    @Override
    public void readArguments(String[] args, CommandLineParser parser) {
        if (parser.getHelpOption() || args.length != 5) {
            this.printUsageAndExit();
        }
        HiCGlobals.normThreads = this.updateNumberOfCPUThreads(parser, 10);
        this.file = args[1];
        this.name = args[2];
        this.resolution = Integer.parseInt(args[3]);
        this.output = args[4];
    }

    @Override
    public void run() {
        HiCGlobals.allowDynamicBlockIndex = false;
        try {
            DatasetReaderV2 reader = new DatasetReaderV2(this.file, false, false);
            Dataset ds = reader.read();
            HiCGlobals.verifySupportedHiCFileVersion(reader.getVersion());
            Chromosome chrom = ds.getChromosomeHandler().getChromosomeFromName(this.name);
            HiCZoom zoom = new HiCZoom(this.resolution);
            String stem = "NORM_" + chrom.getIndex() + "_" + zoom.getBinSize();
            BigContactList ba = IntraNorms.getBigArrayFromAndClearCache(ds, chrom, zoom, 0);
            System.out.println("Contacts loaded to RAM");
            if (ba != null) {
                NormalizationCalculations nc = new NormalizationCalculations(ba, zoom.getBinSize());
                ListOfFloatArrays vc = nc.computeVC();
                long s0 = System.nanoTime();
                ListOfFloatArrays scale = nc.computeSCALE(vc, stem);
                long s1 = System.nanoTime();
                System.out.println("Overall time taken " + (double)(s1 - s0) * 1.0E-9 + " seconds");
                this.export(scale, this.output);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export(ListOfFloatArrays scale, String output) {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(output)), StandardCharsets.UTF_8));
            for (float[] row : scale.getValues()) {
                for (float val : row) {
                    out.println(val);
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }
}

