/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.clt.old;

import hic.tools.clt.CommandLineParser;
import hic.tools.clt.JuiceboxCLT;
import hic.tools.utils.original.Preprocessor;
import hic.tools.utils.original.PreprocessorFromDatasets;
import java.io.File;
import javastraw.reader.Dataset;
import javastraw.tools.HiCFileTools;

public class Sum
extends JuiceboxCLT {
    private String outputFile;
    private PreprocessorFromDatasets pfd;

    public Sum() {
        super(Sum.getBasicUsage() + "\n : [--intra]             only calculate intra chromosomal maps       [default: false]\n : [--near-diagonal]     only retain reads within 10MB of diagonal   [default: false]\n : [-t <string>]         set a temporary directory for writing       [default: temp_folder]\n : [-r <int>]            set the highest resolution to build to      [default: highest available]\n : [--block-size <int>]  scale factor to increase block capacity by  [default: 1]");
    }

    public static String getBasicUsage() {
        return "sum [options] <outfile.hic> <infile1.hic> <infile2.hic> ... <infileN.hic";
    }

    @Override
    public void readArguments(String[] args, CommandLineParser parser) {
        this.outputFile = args[1];
        Dataset[] datasets = new Dataset[args.length - 2];
        for (int z = 2; z < args.length; ++z) {
            datasets[z - 2] = HiCFileTools.extractDatasetForCLT(args[z], false, false, false);
        }
        String tmpDir = parser.getTmpdirOption();
        double hicFileScalingFactor = parser.getScalingOption();
        this.updateNumberOfCPUThreads(parser, 10);
        this.pfd = new PreprocessorFromDatasets(new File(this.outputFile), datasets, hicFileScalingFactor, tmpDir);
        this.pfd.setHighestResolution(parser.getResolutionOption());
        boolean getOnlyNearDiagonal = parser.getOnlyNearDiagonalOption();
        this.pfd.setIntraChromosomalOnly(parser.getDiagonalsOption() || getOnlyNearDiagonal);
        this.pfd.setOnlyNearDiagonalsOnly(getOnlyNearDiagonal);
        int blockCapacity = parser.getBlockCapacityOption();
        if (blockCapacity > 1) {
            Preprocessor.BLOCK_CAPACITY *= blockCapacity;
        }
    }

    @Override
    public void run() {
        try {
            this.pfd.preprocess();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(56);
        }
    }
}

