/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.clt.old;

import hic.HiCGlobals;
import hic.tools.clt.CommandLineParser;
import hic.tools.clt.JuiceboxCLT;
import hic.tools.utils.original.Chunk;
import hic.tools.utils.original.MTIndexHandler;
import hic.tools.utils.stats.LoneStatisticsWorker;
import hic.tools.utils.stats.ParallelStatistics;
import hic.tools.utils.stats.StatisticsContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javastraw.reader.basics.ChromosomeHandler;
import javastraw.reader.basics.ChromosomeTools;

public class Statistics
extends JuiceboxCLT {
    private String siteFile;
    private String ligationJunction = "none";
    private String inFile;
    private String mndIndexFile;
    private ChromosomeHandler localHandler = null;
    private final List<Chunk> mndChunks = new ArrayList<Chunk>();
    private final List<String> statsFiles = new ArrayList<String>();
    private final List<Integer> mapqThresholds = new ArrayList<Integer>();

    public Statistics() {
        super(Statistics.getUsage());
    }

    public static String getUsage() {
        return " Usage: statistics [--ligation NNNN] [--mapqs mapq1,maqp2] [--mndindex mndindex.txt] [--threads numthreads]\n                    <site_file> <stats_file> [stats_file_2] <infile> <genomeID>\n --ligation: ligation junction\n --mapqs: mapping quality threshold(s), do not consider reads < threshold\n --mndindex: file of indices for merged nodups to read from\n --threads: number of threads to be executed \n <site file>: list of HindIII restriction sites, one line per chromosome\n <stats file>: output file containing total reads, for library complexity\n <infile>: file in intermediate format to calculate statistics on, can be stream\n <genome ID>: file to create chromosome handler\n [stats file 2]: output file containing total reads for second mapping quality threshold\n";
    }

    public void setMndIndex() {
        if (this.localHandler != null && this.mndIndexFile != null && this.mndIndexFile.length() > 1) {
            ConcurrentHashMap<Integer, String> chromosomePairIndexes = new ConcurrentHashMap<Integer, String>();
            MTIndexHandler.populateChromosomePairIndexes(this.localHandler, chromosomePairIndexes, new HashMap<String, Integer>(), new HashMap<Integer, Integer>(), new HashMap<Integer, Integer>());
            Map<Integer, List<Chunk>> mndIndex = MTIndexHandler.readMndIndex(this.mndIndexFile, chromosomePairIndexes);
            for (List<Chunk> values2 : mndIndex.values()) {
                this.mndChunks.addAll(values2);
            }
        }
    }

    @Override
    public void readArguments(String[] args, CommandLineParser parser) {
        if (args.length != 6 && args.length != 5) {
            this.printUsageAndExit();
        }
        this.siteFile = args[1];
        this.statsFiles.add(args[2]);
        if (args.length == 6) {
            this.statsFiles.add(args[3]);
            this.inFile = args[4];
            this.tryToReadLocalHandler(args[5]);
        } else {
            this.inFile = args[3];
            this.tryToReadLocalHandler(args[4]);
        }
        List<Integer> mapQT = parser.getMultipleMapQOptions();
        if (mapQT != null && (mapQT.size() == 1 || mapQT.size() == 2)) {
            int mapqThreshold = mapQT.get(0) > 0 ? mapQT.get(0) : 1;
            this.mapqThresholds.add(mapqThreshold);
            if (this.statsFiles.size() == 2) {
                mapqThreshold = 30;
                if (mapQT.size() == 2) {
                    mapqThreshold = mapQT.get(1) > 0 ? mapQT.get(1) : 30;
                }
                this.mapqThresholds.add(mapqThreshold);
            }
        } else {
            this.mapqThresholds.add(1);
            if (this.statsFiles.size() == 2) {
                this.mapqThresholds.add(30);
            }
        }
        String ligJunc = parser.getLigationOption();
        if (ligJunc != null && ligJunc.length() > 1) {
            this.ligationJunction = ligJunc;
        }
        this.updateNumberOfCPUThreads(parser, 1);
        this.mndIndexFile = parser.getMndIndexOption();
    }

    private void tryToReadLocalHandler(String genomeID) {
        this.localHandler = genomeID.equalsIgnoreCase("na") || genomeID.equalsIgnoreCase("null") || genomeID.equalsIgnoreCase("none") ? null : ChromosomeTools.loadChromosomes(genomeID);
    }

    @Override
    public void run() {
        StatisticsContainer container;
        this.setMndIndex();
        int numCPUThreads = HiCGlobals.primaryThreads;
        if (this.localHandler == null || this.mndChunks.size() < 2 || numCPUThreads == 1) {
            LoneStatisticsWorker runner = new LoneStatisticsWorker(this.siteFile, this.statsFiles, this.mapqThresholds, this.ligationJunction, this.inFile);
            runner.infileStatistics();
            container = runner.getResultsContainer();
        } else {
            container = new StatisticsContainer();
            ParallelStatistics pStats = new ParallelStatistics(numCPUThreads, container, this.mndChunks, this.siteFile, this.statsFiles, this.mapqThresholds, this.ligationJunction, this.inFile, this.localHandler);
            pStats.launchThreads();
        }
        container.calculateConvergence(this.statsFiles.size());
        container.outputStatsFile(this.statsFiles);
        container.writeHistFile(this.statsFiles);
    }
}

