/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.clt.old;

import hic.HiCGlobals;
import hic.tools.clt.CommandLineParser;
import hic.tools.clt.JuiceboxCLT;
import hic.tools.clt.old.AddNorm;
import hic.tools.utils.ShellCommandRunner;
import hic.tools.utils.original.MultithreadedPreprocessor;
import hic.tools.utils.original.Preprocessor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javastraw.reader.type.NormalizationType;

public class PreProcessing
extends JuiceboxCLT {
    private String inputFile;
    private String outputFile;
    private Preprocessor preprocessor;
    private boolean noNorm = false;
    private boolean noFragNorm = false;
    private int genomeWide;
    private String shell = "sh";
    private final List<NormalizationType> normalizationTypes = new ArrayList<NormalizationType>();

    public PreProcessing() {
        super(PreProcessing.getBasicUsage() + "\n           : --intra only calculate intra chromosomal maps [false]\n           : --near-diagonal only retain reads within 10MB of diagonal [false]\n           : --block-size <int> set block capacity [1000]\n           : -m <int> only write cells with count above threshold m [0]\n           : -q <int> filter by MAPQ score greater than or equal to q [not set]\n           : -c <chromosome ID> only calculate map on specific chromosome [not set]\n           : -r <comma-separated list of resolutions> Only calculate specific resolutions [not set]\n           : -t <tmpDir> Set a temporary directory for writing\n           : -s <statistics file> Add the text statistics file to the Hi-C file header\n           : -g <graphs file> Add the text graphs file to the Hi-C file header\n           : -n Don't normalize the matrices\n           : -z <double> scale factor for hic file\n           : -a <1, 2, 3, 4, 5> filter based on inner, outer, left-left, right-right, tandem pairs respectively\n           : --random_seed <long> for seeding random number generator\n           : -k normalizations to include\n           : -j number of CPU threads to use\n           : --threads <int> number of threads \n           : --mndindex <filepath> to mnd chr block indices\n           : --conserve-ram will minimize RAM usage\n           : --check-ram-usage will check ram requirements prior to running\n           : --shell how to execute shell (sh, bash, zsh, etc); default: sh");
    }

    public static String getBasicUsage() {
        return "pre [options] <infile> <outfile> <genomeID>";
    }

    @Override
    public void readArguments(String[] args, CommandLineParser parser) {
        String customShell;
        String genomeId = "";
        try {
            genomeId = args[3];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("No genome ID given");
            this.printUsageAndExit();
        }
        this.inputFile = args[1];
        this.outputFile = args[2];
        String tmpDir = parser.getTmpdirOption();
        double hicFileScalingFactor = parser.getScalingOption();
        HiCGlobals.primaryThreads = this.updateNumberOfCPUThreads(parser, 1);
        HiCGlobals.normThreads = this.updateSecondaryNumberOfCPUThreads(parser, 10);
        if (HiCGlobals.primaryThreads < 2) {
            this.preprocessor = new Preprocessor(new File(this.outputFile), genomeId, hicFileScalingFactor, tmpDir);
            this.usingMultiThreadedVersion = false;
        } else {
            try {
                this.preprocessor = new MultithreadedPreprocessor(new File(this.outputFile), genomeId, hicFileScalingFactor, HiCGlobals.primaryThreads, parser.getMndIndexOption(), tmpDir);
                this.usingMultiThreadedVersion = true;
            }
            catch (Exception e) {
                System.err.println(e.getLocalizedMessage() + "\nUsing single threaded preprocessor");
                this.preprocessor = new Preprocessor(new File(this.outputFile), genomeId, hicFileScalingFactor, tmpDir);
                this.usingMultiThreadedVersion = false;
            }
        }
        this.preprocessor.setIncludedChromosomes(parser.getChromosomeSetOption());
        this.preprocessor.setCountThreshold(parser.getCountThresholdOption());
        this.preprocessor.setV9DepthBase(parser.getV9DepthBase());
        this.preprocessor.setMapqThreshold(parser.getMapqThresholdOption());
        this.preprocessor.setIntraChromosomalOnly(parser.getDiagonalsOption());
        this.preprocessor.setStatisticsFile(parser.getStatsOption());
        this.preprocessor.setGraphFile(parser.getGraphOption());
        this.preprocessor.setGenome(parser.getGenomeOption());
        this.preprocessor.setResolutions(parser.getResolutionOption());
        this.preprocessor.setFilter(parser.getAlignmentOption());
        int blockCapacity = parser.getBlockCapacityOption();
        if (blockCapacity > 10) {
            Preprocessor.BLOCK_CAPACITY = blockCapacity;
        }
        if ((customShell = parser.getShellOption()) != null && customShell.length() > 0) {
            this.shell = customShell;
        }
        this.noNorm = parser.getNoNormOption();
        this.genomeWide = parser.getGenomeWideOption();
        this.noFragNorm = parser.getNoFragNormOption();
        this.normalizationTypes.addAll(parser.getAllNormalizationTypesOption());
    }

    @Override
    public void run() {
        try {
            long currentTime = System.currentTimeMillis();
            if (this.usingMultiThreadedVersion) {
                this.preprocessor.preprocess(this.inputFile, null, null, null);
                ShellCommandRunner.runShellFile(this.shell, this.outputFile + "_cat_outputs.sh");
            } else {
                this.preprocessor.preprocess(this.inputFile, this.outputFile, this.outputFile, null);
            }
            if (HiCGlobals.printVerboseComments) {
                System.out.println("\nBinning contact matrices took: " + (System.currentTimeMillis() - currentTime) + " milliseconds");
            }
            if (!this.noNorm) {
                Map<NormalizationType, Integer> resolutionsToBuildTo = AddNorm.defaultHashMapForResToBuildTo(this.normalizationTypes);
                AddNorm.launch(this.outputFile, this.normalizationTypes, 0, resolutionsToBuildTo);
            } else {
                System.out.println("Done creating .hic file. Normalization not calculated due to -n flag.");
                System.out.println("To run normalization, run: java -jar juicer_tools.jar addNorm <hicfile>");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(56);
        }
    }
}

