/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.clt.old;

import hic.HiCGlobals;
import hic.tools.clt.CommandLineParser;
import hic.tools.clt.JuiceboxCLT;
import htsjdk.tribble.util.LittleEndianOutputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javastraw.matrices.BasicMatrix;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.basics.ChromosomeHandler;
import javastraw.reader.expected.ExpectedValueFunction;
import javastraw.reader.mzd.MatrixZoomData;
import javastraw.reader.type.HiCZoom;
import javastraw.tools.HiCFileTools;

public class Pearsons
extends JuiceboxCLT {
    private static final int BLOCK_TILE = 500;
    private String ofile = null;
    private HiCZoom.HiCUnit unit = null;
    private int binSize = 0;
    private Chromosome chromosome1;

    public Pearsons() {
        super(Pearsons.getBasicUsage() + "\n\t-p, --pearsons_all_resolutions: calculate Pearson's at all resolutions");
    }

    public static String getBasicUsage() {
        return "pearsons [-p] <NONE/VC/VC_SQRT/KR> <hicFile(s)> <chr> <BP/FRAG> <binsize> [outfile]";
    }

    @Override
    public void readArguments(String[] args, CommandLineParser parser) {
        if (args.length != 7 && args.length != 6) {
            this.printUsageAndExit();
        }
        this.setDatasetAndNorm(args[2], args[1], true);
        ChromosomeHandler chromosomeHandler = this.dataset.getChromosomeHandler();
        if (chromosomeHandler.doesNotContainChromosome(args[3])) {
            System.err.println("Unknown chromosome: " + args[3]);
            System.exit(18);
        }
        this.chromosome1 = chromosomeHandler.getChromosomeFromName(args[3]);
        try {
            this.unit = HiCZoom.valueOfUnit(args[4]);
        }
        catch (IllegalArgumentException error) {
            System.err.println("Unit must be in BP or FRAG.");
            System.exit(20);
        }
        String binSizeSt = args[5];
        try {
            this.binSize = Integer.parseInt(binSizeSt);
        }
        catch (NumberFormatException e) {
            System.err.println("Integer expected for bin size.  Found: " + binSizeSt + ".");
            System.exit(21);
        }
        if (this.unit == HiCZoom.HiCUnit.BP && this.binSize < HiCGlobals.MAX_PEARSON_ZOOM || this.unit == HiCZoom.HiCUnit.FRAG && this.binSize < HiCGlobals.MAX_PEARSON_ZOOM / 1000) {
            System.out.println("Pearson's and Eigenvector are not calculated for high resolution datasets");
            System.out.println("To override this limitation, send in the \"-p\" flag.");
            System.exit(0);
        }
        if (args.length == 7) {
            this.ofile = args[6];
        }
    }

    @Override
    public void run() {
        PrintWriter txtWriter;
        LittleEndianOutputStream les;
        BasicMatrix pearsons;
        block19: {
            ExpectedValueFunction df;
            HiCZoom zoom = new HiCZoom(this.unit, this.binSize);
            MatrixZoomData zd = HiCFileTools.getMatrixZoomData(this.dataset, this.chromosome1, this.chromosome1, zoom);
            if (zd == null) {
                int zoomIdx;
                System.err.println("No reads in " + this.chromosome1);
                System.err.println("Unknown resolution: " + zoom);
                System.err.println("This data set has the following bin sizes (in bp): ");
                for (zoomIdx = 0; zoomIdx < this.dataset.getNumberZooms(HiCZoom.HiCUnit.BP); ++zoomIdx) {
                    System.err.print(this.dataset.getZoom(HiCZoom.HiCUnit.BP, zoomIdx).getBinSize() + " ");
                }
                System.err.println("\nand the following bin sizes (in frag): ");
                for (zoomIdx = 0; zoomIdx < this.dataset.getNumberZooms(HiCZoom.HiCUnit.FRAG); ++zoomIdx) {
                    System.err.print(this.dataset.getZoom(HiCZoom.HiCUnit.FRAG, zoomIdx).getBinSize() + " ");
                }
                System.exit(13);
            }
            if ((pearsons = zd.getPearsons(df = this.dataset.getExpectedValuesOrExit(zd.getZoom(), this.norm, true, true))) == null) {
                System.err.println("Pearson's not available at zoom " + zoom + ". For high resolution, try again with -p");
                System.exit(15);
            }
            les = null;
            txtWriter = null;
            if (this.ofile != null) {
                try {
                    if (this.ofile.endsWith(".bin")) {
                        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.ofile));
                        les = new LittleEndianOutputStream(bos);
                        break block19;
                    }
                    txtWriter = new PrintWriter(new FileOutputStream(this.ofile));
                }
                catch (IOException error) {
                    System.err.println("Cannot write to " + this.ofile);
                    error.printStackTrace();
                    System.exit(22);
                }
            } else {
                txtWriter = new PrintWriter(System.out);
            }
        }
        if (les == null) {
            int dim = pearsons.getRowDimension();
            for (int i = 0; i < dim; ++i) {
                for (int j = 0; j < dim; ++j) {
                    float output = pearsons.getEntry(i, j);
                    txtWriter.print(output + " ");
                }
                txtWriter.println();
            }
            txtWriter.flush();
        } else {
            try {
                int dim = pearsons.getRowDimension();
                this.writeHeader(les, dim, pearsons.getLowerValue(), pearsons.getUpperValue());
                int block_side = (int)Math.ceil((float)dim / 500.0f);
                for (int i = 0; i < block_side; ++i) {
                    int block_row_start = i * 500;
                    int block_row_end = Math.min(block_row_start + 500, dim);
                    int row_len = block_row_end - block_row_start;
                    for (int j = 0; j < block_side; ++j) {
                        int block_col_start = j * 500;
                        int block_col_end = Math.min(block_col_start + 500, dim);
                        int col_len = block_col_end - block_col_start;
                        for (int ui = 0; ui < row_len; ++ui) {
                            for (int uj = 0; uj < col_len; ++uj) {
                                int now_i = ui + block_row_start;
                                int now_j = uj + block_col_start;
                                float output = pearsons.getEntry(now_i, now_j);
                                les.writeFloat(output);
                            }
                        }
                    }
                }
                les.close();
            }
            catch (IOException error) {
                System.err.println("Problem when writing Pearson's");
                error.printStackTrace();
                System.exit(1);
            }
        }
    }

    private void writeHeader(LittleEndianOutputStream les, int dim, float lower, float upper) throws IOException {
        les.writeByte(104);
        les.writeByte(105);
        les.writeByte(99);
        les.writeByte(0);
        les.writeInt(1);
        les.writeString(this.dataset.getGenomeId());
        les.writeString(this.chromosome1.getName());
        les.writeString(this.chromosome1.getName());
        les.writeInt(this.binSize);
        les.writeFloat(lower);
        les.writeFloat(upper);
        les.writeInt(dim);
        les.writeInt(dim);
        les.writeInt(500);
    }
}

