/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.clt.old;

import hic.tools.clt.CommandLineParser;
import hic.tools.clt.JuiceboxCLT;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;

public class LibraryComplexity
extends JuiceboxCLT {
    private String localWorkingDirectory;
    private long dupReadPairs = 0L;
    private long uniqueReadPairs = 0L;
    private long opticalDups = 0L;
    private long totalReadPairs = 0L;
    private String fileName = "inter.txt";
    private final boolean filesAlreadyCounted;

    public LibraryComplexity(String command) {
        super(LibraryComplexity.getUsage());
        this.filesAlreadyCounted = command.contains("fast");
    }

    private static String getUsage() {
        return "LibraryComplexity <directory> <output file>\nFastLibraryComplexity <file> <output file>\nFastLibraryComplexity <unique> <pcr> <opt>";
    }

    public static long estimateLibrarySize(long duplicateReadPairs, long uniqueReadPairs) {
        long totalReadPairs = duplicateReadPairs + uniqueReadPairs;
        if (totalReadPairs > 0L && duplicateReadPairs > 0L) {
            int i;
            double m = 1.0;
            double M = 100.0;
            if (uniqueReadPairs >= totalReadPairs || LibraryComplexity.f(m * (double)uniqueReadPairs, uniqueReadPairs, totalReadPairs) < 0.0) {
                throw new IllegalStateException("Invalid values for pairs and unique pairs: " + totalReadPairs + ", " + uniqueReadPairs);
            }
            while (LibraryComplexity.f(M * (double)uniqueReadPairs, uniqueReadPairs, totalReadPairs) >= 0.0) {
                m = M;
                M *= 10.0;
            }
            double r = (m + M) / 2.0;
            double u = LibraryComplexity.f(r * (double)uniqueReadPairs, uniqueReadPairs, totalReadPairs);
            for (i = 0; u != 0.0 && i < 1000; ++i) {
                if (u > 0.0) {
                    m = r;
                } else {
                    M = r;
                }
                r = (m + M) / 2.0;
                u = LibraryComplexity.f(r * (double)uniqueReadPairs, uniqueReadPairs, totalReadPairs);
            }
            if (i == 1000) {
                System.err.println("Iterated 1000 times, returning estimate");
            }
            return (long)((double)uniqueReadPairs * (m + M) / 2.0);
        }
        return 0L;
    }

    private static double f(double x, double c, double n) {
        return c / x - 1.0 + Math.exp(-n / x);
    }

    @Override
    public void readArguments(String[] args, CommandLineParser parser) {
        if (args.length != 2 && args.length != 3 && args.length != 4) {
            System.out.println(LibraryComplexity.getUsage());
            System.exit(0);
        }
        if (this.filesAlreadyCounted) {
            if (args.length == 4) {
                try {
                    this.determineCountsFromInput(args);
                }
                catch (NumberFormatException error) {
                    System.err.println("When called with three arguments, must be integers");
                    System.exit(1);
                }
            } else {
                try {
                    this.determineCountsFromFile(args[1]);
                    if (args.length == 3) {
                        this.fileName = args[2];
                    }
                }
                catch (Exception error) {
                    System.err.println(error.getLocalizedMessage());
                    System.exit(1);
                }
            }
        } else if (args.length == 3 || args.length == 2) {
            this.localWorkingDirectory = args[1];
            if (args.length == 3) {
                this.fileName = args[2];
            }
        }
    }

    private void determineCountsFromFile(String file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        this.dupReadPairs = Long.parseLong(reader.readLine().trim());
        this.uniqueReadPairs = Long.parseLong(reader.readLine().trim());
        try {
            this.opticalDups = Long.parseLong(reader.readLine().trim());
        }
        catch (Exception e) {
            this.opticalDups = 0L;
        }
        reader.close();
    }

    private void determineCountsFromInput(String[] args) throws NumberFormatException {
        this.uniqueReadPairs = Long.parseLong(args[1]);
        this.dupReadPairs = Long.parseLong(args[2]);
        this.opticalDups = Long.parseLong(args[3]);
    }

    @Override
    public void run() {
        long result;
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        if (!this.filesAlreadyCounted) {
            AtomicBoolean somethingFailed = new AtomicBoolean(false);
            try {
                ExecutorService executor = Executors.newFixedThreadPool(3);
                Callable<Long> taskOptDups = () -> {
                    File f = new File(this.localWorkingDirectory + "/opt_dups.txt");
                    return this.getFileLength(somethingFailed, f);
                };
                Callable<Long> taskUniqueReads = () -> {
                    File f = new File(this.localWorkingDirectory + "/merged_nodups.txt");
                    return this.getFileLength(somethingFailed, f);
                };
                Callable<Long> taskDupReadPairs = () -> {
                    File f = new File(this.localWorkingDirectory + "/dups.txt");
                    return this.getFileLength(somethingFailed, f);
                };
                Future<Long> futureOptDups = executor.submit(taskOptDups);
                Future<Long> futureUniqueReads = executor.submit(taskUniqueReads);
                Future<Long> futureDupReadPairs = executor.submit(taskDupReadPairs);
                File f = new File(this.localWorkingDirectory + "/" + this.fileName);
                if (f.exists()) {
                    BufferedReader reader = new BufferedReader(new FileReader(this.localWorkingDirectory + "/" + this.fileName));
                    String line = reader.readLine();
                    boolean done = false;
                    while (line != null && !done) {
                        if (line.contains("Sequenced Read")) {
                            String[] parts = line.split(":");
                            try {
                                this.totalReadPairs = nf.parse(parts[1].trim()).longValue();
                            }
                            catch (ParseException parseException) {
                                // empty catch block
                            }
                            done = true;
                        }
                        line = reader.readLine();
                    }
                    reader.close();
                }
                this.opticalDups = futureOptDups.get();
                this.uniqueReadPairs = futureUniqueReads.get();
                this.dupReadPairs = futureDupReadPairs.get();
                executor.shutdown();
                if (somethingFailed.get()) {
                    System.err.println("Something failed in a thread");
                    System.exit(1);
                }
            }
            catch (IOException error) {
                System.err.println("Problem counting lines in merged_nodups and dups");
                System.exit(1);
            }
            catch (InterruptedException e) {
                System.err.println("Threads interrupted exception");
                System.exit(1);
            }
            catch (ExecutionException e) {
                System.err.println("Threads execution exception");
                System.exit(1);
            }
        }
        NumberFormat decimalFormat = NumberFormat.getPercentInstance();
        decimalFormat.setMinimumFractionDigits(2);
        decimalFormat.setMaximumFractionDigits(2);
        System.out.print("Unique Reads: " + NumberFormat.getInstance().format(this.uniqueReadPairs) + " ");
        if (this.totalReadPairs > 0L) {
            System.out.println("(" + decimalFormat.format((double)this.uniqueReadPairs / (double)this.totalReadPairs) + ")");
        } else {
            System.out.println();
        }
        System.out.print("PCR Duplicates: " + nf.format(this.dupReadPairs) + " ");
        if (this.totalReadPairs > 0L) {
            System.out.println("(" + decimalFormat.format((double)this.dupReadPairs / (double)this.totalReadPairs) + ")");
        } else {
            System.out.println();
        }
        System.out.print("Optical Duplicates: " + nf.format(this.opticalDups) + " ");
        if (this.totalReadPairs > 0L) {
            System.out.println("(" + decimalFormat.format((double)this.opticalDups / (double)this.totalReadPairs) + ")");
        } else {
            System.out.println();
        }
        try {
            result = LibraryComplexity.estimateLibrarySize(this.dupReadPairs, this.uniqueReadPairs);
        }
        catch (NullPointerException e) {
            result = 0L;
        }
        System.out.println("Library Complexity Estimate: " + nf.format(result));
    }

    private Long getFileLength(AtomicBoolean somethingFailed, File f) {
        if (f.exists()) {
            try {
                long value = 0L;
                BufferedReader reader = new BufferedReader(new FileReader(f));
                while (reader.readLine() != null) {
                    ++value;
                }
                reader.close();
                return value;
            }
            catch (Exception e) {
                somethingFailed.set(true);
                return 0L;
            }
        }
        return 0L;
    }
}

