/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.clt.old;

import hic.tools.clt.CommandLineParser;
import hic.tools.clt.JuiceboxCLT;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.basics.ChromosomeHandler;
import javastraw.reader.expected.ExpectedValueFunction;
import javastraw.reader.mzd.MatrixZoomData;
import javastraw.reader.type.HiCZoom;
import javastraw.tools.HiCFileTools;

public class Eigenvector
extends JuiceboxCLT {
    private HiCZoom.HiCUnit unit = null;
    private int binSize = 0;
    private Chromosome chromosome1;
    private PrintWriter pw;

    public Eigenvector() {
        super(Eigenvector.getUsage() + "\n\t-p, --pearsons_all_resolutions: calculate eigenvector at all resolutions");
    }

    public static String getUsage() {
        return "eigenvector -p <NONE/VC/VC_SQRT/KR> <hicFile(s)> <chr> <BP/FRAG> <binsize> [outfile]";
    }

    @Override
    public void readArguments(String[] args, CommandLineParser parser) {
        if (args.length != 7 && args.length != 6) {
            this.printUsageAndExit();
        }
        this.setDatasetAndNorm(args[2], args[1], false);
        ChromosomeHandler chromosomeHandler = this.dataset.getChromosomeHandler();
        if (chromosomeHandler.doesNotContainChromosome(args[3])) {
            System.err.println("Unknown chromosome: " + args[3]);
            System.exit(18);
        }
        this.chromosome1 = chromosomeHandler.getChromosomeFromName(args[3]);
        try {
            this.unit = HiCZoom.valueOfUnit(args[4]);
        }
        catch (IllegalArgumentException error) {
            System.err.println("Unit must be in BP or FRAG.");
            System.exit(20);
        }
        String binSizeSt = args[5];
        try {
            this.binSize = Integer.parseInt(binSizeSt);
        }
        catch (NumberFormatException e) {
            System.err.println("Integer expected for bin size.  Found: " + binSizeSt + ".");
            System.exit(21);
        }
        if (this.unit == HiCZoom.HiCUnit.BP && this.binSize < 250000 || this.unit == HiCZoom.HiCUnit.FRAG && this.binSize < 250) {
            System.out.println("WARNING: Eigenvector calculation at high resolution can take a long time");
        }
        if (args.length == 7) {
            try {
                this.pw = new PrintWriter(new FileOutputStream(args[6]));
            }
            catch (IOException error) {
                System.err.println("Cannot write to " + args[6]);
                error.printStackTrace();
                System.exit(22);
            }
        } else {
            this.pw = new PrintWriter(System.out);
        }
    }

    @Override
    public void run() {
        HiCZoom zoom = new HiCZoom(this.unit, this.binSize);
        MatrixZoomData zd = HiCFileTools.getMatrixZoomData(this.dataset, this.chromosome1, this.chromosome1, zoom);
        if (zd == null) {
            int zoomIdx;
            System.err.println("No reads in " + this.chromosome1);
            System.err.println("Unknown resolution: " + zoom);
            System.err.println("This data set has the following bin sizes (in bp): ");
            for (zoomIdx = 0; zoomIdx < this.dataset.getNumberZooms(HiCZoom.HiCUnit.BP); ++zoomIdx) {
                System.err.print(this.dataset.getZoom(HiCZoom.HiCUnit.BP, zoomIdx).getBinSize() + " ");
            }
            System.err.println("\nand the following bin sizes (in frag): ");
            for (zoomIdx = 0; zoomIdx < this.dataset.getNumberZooms(HiCZoom.HiCUnit.FRAG); ++zoomIdx) {
                System.err.print(this.dataset.getZoom(HiCZoom.HiCUnit.FRAG, zoomIdx).getBinSize() + " ");
            }
            System.exit(13);
        }
        ExpectedValueFunction df = this.dataset.getExpectedValuesOrExit(zd.getZoom(), this.norm, true, true);
        double[] vector = zd.getEigenvector(df, 0);
        int count = 0;
        double total = 0.0;
        for (double element : vector) {
            if (Double.isNaN(element)) continue;
            total += element;
            ++count;
        }
        double mean = total / (double)count;
        for (double element : vector) {
            this.pw.println(element - mean);
        }
        this.pw.close();
    }
}

