/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.clt.old;

import hic.tools.clt.CommandLineParser;
import hic.tools.clt.JuiceboxCLT;
import hic.tools.utils.other.BigWigUtils;

public class BigWig
extends JuiceboxCLT {
    private int version = -1;
    private int start = -1;
    private int end = -1;
    private int windowSize = -1;
    private String chr;
    private String path;

    public BigWig() {
        super("bigWig <bigWig path or URL> <window size in bp> [chr] [start base] [end base]");
    }

    @Override
    public void readArguments(String[] args, CommandLineParser parser) {
        if (args.length != 3 && args.length != 4 && args.length != 6) {
            this.printUsageAndExit();
        }
        this.path = args[1];
        this.windowSize = Integer.parseInt(args[2]);
        if (args.length == 3) {
            this.version = 0;
        } else {
            this.chr = args[3];
            if (args.length == 4) {
                this.version = 1;
            } else {
                this.start = Integer.parseInt(args[4]) - 1;
                this.end = Integer.parseInt(args[5]);
                this.version = 2;
            }
        }
    }

    @Override
    public void run() {
        try {
            if (this.version == 0) {
                BigWigUtils.computeBins(this.path, this.windowSize);
            } else if (this.version == 1) {
                BigWigUtils.computeBins(this.path, this.chr, 0, Integer.MAX_VALUE, this.windowSize);
            } else if (this.version == 2) {
                BigWigUtils.computeBins(this.path, this.chr, this.start, this.end, this.windowSize);
            } else {
                System.err.println("Invalid Option Setup");
                this.printUsageAndExit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

