/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.clt.old;

import hic.HiCGlobals;
import hic.tools.clt.CommandLineParser;
import hic.tools.clt.JuiceboxCLT;
import hic.tools.clt.old.NormalizationBuilder;
import hic.tools.utils.norm.CustomNormVectorFileHandler;
import hic.tools.utils.norm.NormalizationVectorUpdater;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javastraw.reader.type.NormalizationType;

public class AddNorm
extends JuiceboxCLT {
    private String inputVectorFile = null;
    private int ramSavePoint = 0;
    private String file;
    private final List<NormalizationType> normalizationTypes = new ArrayList<NormalizationType>();
    private Map<NormalizationType, Integer> resolutionsToBuildTo;

    public AddNorm() {
        super(AddNorm.getBasicUsage() + "\n           : -d use intra chromosome (diagonal) [false]\n           : -F don't calculate normalization for fragment-delimited maps [false]\n           : -w <int> calculate genome-wide resolution on all resolutions >= input resolution [not set]\n Above options ignored if input_vector_file present\n           : -k normalizations to include\n           : -r resolutions for respective normalizations to build to\n           : -j number of CPU threads to use\n           : --conserve-ram will minimize RAM usage\n           : --check-ram-usage will check ram requirements prior to running");
    }

    public static String getBasicUsage() {
        return "addNorm <input_HiC_file> [input_vector_file]";
    }

    public static Map<NormalizationType, Integer> defaultHashMapForResToBuildTo(List<NormalizationType> normalizationTypes) {
        HashMap<NormalizationType, Integer> map = new HashMap<NormalizationType, Integer>();
        for (NormalizationType norm : normalizationTypes) {
            map.put(norm, NormalizationBuilder.getIdealResolutionLimit(norm));
        }
        return map;
    }

    public static void launch(String outputFile, List<NormalizationType> normalizationTypes, int ramSavePoint, Map<NormalizationType, Integer> resolutionsToBuildTo) throws IOException {
        HiCGlobals.useCache = false;
        NormalizationVectorUpdater updater = new NormalizationVectorUpdater();
        updater.updateHicFile(outputFile, normalizationTypes, resolutionsToBuildTo, ramSavePoint);
    }

    @Override
    public void readArguments(String[] args, CommandLineParser parser) {
        if (parser.getHelpOption()) {
            this.printUsageAndExit();
        }
        if (args.length == 3) {
            this.inputVectorFile = args[2];
        } else if (args.length != 2) {
            this.printUsageAndExit();
        }
        HiCGlobals.normThreads = this.updateNumberOfCPUThreads(parser, 10);
        this.usingMultiThreadedVersion = HiCGlobals.normThreads > 1;
        HiCGlobals.chromThreads = this.updateSecondaryNumberOfCPUThreads(parser, 1);
        this.normalizationTypes.addAll(parser.getAllNormalizationTypesOption());
        this.resolutionsToBuildTo = AddNorm.defaultHashMapForResToBuildTo(this.normalizationTypes);
        this.ramSavePoint = parser.getRamSavePoint();
        List<String> resolutions = parser.getResolutionOption();
        if (resolutions != null && resolutions.size() > 0) {
            if (resolutions.size() != this.normalizationTypes.size()) {
                System.err.println("Error: Number of resolutions and normalizations need to be the same");
                System.exit(0);
            }
            for (int k = 0; k < resolutions.size(); ++k) {
                NormalizationType normType = this.normalizationTypes.get(k);
                try {
                    int resVal = Integer.parseInt(resolutions.get(k));
                    this.resolutionsToBuildTo.put(normType, resVal);
                    continue;
                }
                catch (Exception e) {
                    this.resolutionsToBuildTo.put(normType, NormalizationBuilder.getIdealResolutionLimit(normType));
                }
            }
        }
        this.file = args[1];
    }

    @Override
    public void run() {
        HiCGlobals.allowDynamicBlockIndex = false;
        try {
            if (this.inputVectorFile != null) {
                CustomNormVectorFileHandler.updateHicFile(this.file, this.inputVectorFile);
            } else {
                AddNorm.launch(this.file, this.normalizationTypes, this.ramSavePoint, this.resolutionsToBuildTo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

