/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.clt;

import hic.tools.clt.CommandLineParser;
import javastraw.reader.Dataset;
import javastraw.reader.type.NormalizationType;
import javastraw.tools.HiCFileTools;

public abstract class JuiceboxCLT {
    private static String usage;
    protected Dataset dataset = null;
    protected NormalizationType norm = null;
    protected boolean usingMultiThreadedVersion = false;

    protected JuiceboxCLT(String usage) {
        this.setUsage(usage);
    }

    public static String[] splitToList(String nextLine) {
        return nextLine.trim().split("\\s+");
    }

    public abstract void readArguments(String[] var1, CommandLineParser var2);

    public abstract void run();

    private void setUsage(String newUsage) {
        usage = newUsage;
    }

    public void printUsageAndExit() {
        System.out.println("Usage:   juicer_tools " + usage);
        System.exit(0);
    }

    public void printUsageAndExit(int exitcode) {
        System.out.println("Usage:   juicer_tools " + usage);
        System.exit(exitcode);
    }

    protected void setDatasetAndNorm(String file, String normType, boolean allowPrinting) {
        this.dataset = HiCFileTools.extractDatasetForCLT(file, allowPrinting, false, false);
        this.norm = this.dataset.getNormalizationHandler().getNormTypeFromString(normType);
        if (this.norm == null) {
            System.err.println("Normalization type " + this.norm + " unrecognized.  Normalization type must be one of \n\"NONE\", \"VC\", \"VC_SQRT\", \"KR\", \"GW_KR\", \"GW_VC\", \"INTER_KR\", \"INTER_VC\", or a custom added normalization.");
            System.exit(16);
        }
    }

    public static int getAppropriateNumberOfThreads(int numThreads, int defaultNum) {
        if (numThreads > 0) {
            return numThreads;
        }
        if (numThreads < 0) {
            return Math.abs(numThreads) * Runtime.getRuntime().availableProcessors();
        }
        return defaultNum;
    }

    protected int updateNumberOfCPUThreads(CommandLineParser parser, int numDefaultThreads) {
        int numCPUThreads = JuiceboxCLT.getAppropriateNumberOfThreads(parser.getNumThreads(), numDefaultThreads);
        System.out.println("Using " + numCPUThreads + " CPU thread(s) for primary task");
        return numCPUThreads;
    }

    protected int updateSecondaryNumberOfCPUThreads(CommandLineParser parser, int numDefaultThreads) {
        int numCPUThreadsForSecondTask = JuiceboxCLT.getAppropriateNumberOfThreads(parser.getNumMatrixOperationThreads(), numDefaultThreads);
        System.out.println("Using " + numCPUThreadsForSecondTask + " CPU thread(s) for secondary task");
        return numCPUThreadsForSecondTask;
    }
}

