/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.clt;

import hic.tools.utils.iterators.mnd.ReadPairFilter;
import jargs.gnu.CmdLineParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javastraw.reader.type.NormalizationHandler;
import javastraw.reader.type.NormalizationType;

public class CommandLineParser
extends CmdLineParser {
    protected final CmdLineParser.Option verboseOption = this.addBooleanOption('v', "verbose");
    protected final CmdLineParser.Option helpOption = this.addBooleanOption('h', "help");
    protected final CmdLineParser.Option versionOption = this.addBooleanOption('V', "version");
    private final CmdLineParser.Option diagonalsOption = this.addBooleanOption("intra");
    private final CmdLineParser.Option onlyNearDiagonalsOption = this.addBooleanOption("near-diagonal");
    private final CmdLineParser.Option removeCacheMemoryOption = this.addBooleanOption('x', "remove-memory-cache");
    private final CmdLineParser.Option noNormOption = this.addBooleanOption('n', "no_normalization");
    private final CmdLineParser.Option allPearsonsOption = this.addBooleanOption('p', "pearsons-all-resolutions");
    private final CmdLineParser.Option noFragNormOption = this.addBooleanOption('F', "no_fragment-normalization");
    private final CmdLineParser.Option randomizePositionOption = this.addBooleanOption("randomize_position");
    private final CmdLineParser.Option throwIntraFragOption = this.addBooleanOption("skip-intra-frag");
    private final CmdLineParser.Option fragmentOption = this.addStringOption('f', "restriction-fragment-site-file");
    private final CmdLineParser.Option tmpDirOption = this.addStringOption('t', "tmpdir");
    private final CmdLineParser.Option statsOption = this.addStringOption('s', "statistics");
    private final CmdLineParser.Option graphOption = this.addStringOption('g', "graphs");
    private final CmdLineParser.Option genomeIDOption = this.addStringOption('y', "genomeid");
    protected final CmdLineParser.Option normalizationTypeOption = this.addStringOption('k', "normalization");
    private final CmdLineParser.Option mndIndexOption = this.addStringOption('i', "mndindex");
    private final CmdLineParser.Option ligationOption = this.addStringOption("ligation");
    private final CmdLineParser.Option shellOption = this.addStringOption("shell");
    private final CmdLineParser.Option blockCapacityOption = this.addIntegerOption("block-size");
    private final CmdLineParser.Option countThresholdOption = this.addIntegerOption('m', "min-count");
    private final CmdLineParser.Option mapqOption = this.addIntegerOption('q', "mapq");
    private final CmdLineParser.Option genomeWideOption = this.addIntegerOption('w', "genomewide");
    private final CmdLineParser.Option nearDiagonalOption = this.addIntegerOption("diagonal-cutoff");
    private final CmdLineParser.Option alignmentFilterOption = this.addIntegerOption("alignment");
    private final CmdLineParser.Option threadNumOption = this.addIntegerOption('j', "threads");
    private final CmdLineParser.Option matrixThreadNumOption = this.addIntegerOption("mthreads");
    private final CmdLineParser.Option v9DepthBaseOption = this.addIntegerOption("v9-depth-base");
    private final CmdLineParser.Option initOption = this.addIntegerOption("initial");
    private final CmdLineParser.Option ramSavePointOption = this.addIntegerOption("save-ram");
    private final CmdLineParser.Option multipleChromosomesOption = this.addStringOption('c', "chromosomes");
    private final CmdLineParser.Option resolutionOption = this.addStringOption('r', "resolutions");
    private final CmdLineParser.Option randomizePositionMapsOption = this.addStringOption("frag-site-maps");
    private final CmdLineParser.Option multipleMapQOption = this.addStringOption("mapqs");
    private final CmdLineParser.Option hicFileScalingOption = this.addDoubleOption('z', "scale");
    private final CmdLineParser.Option randomSeedOption = this.addLongOption("random-seed");

    protected boolean optionToBoolean(CmdLineParser.Option option) {
        Object opt = this.getOptionValue(option);
        return opt != null && (Boolean)opt != false;
    }

    public boolean getHelpOption() {
        return this.optionToBoolean(this.helpOption);
    }

    public boolean getDiagonalsOption() {
        return this.optionToBoolean(this.diagonalsOption);
    }

    public boolean getOnlyNearDiagonalOption() {
        return this.optionToBoolean(this.onlyNearDiagonalsOption);
    }

    public boolean useCacheMemory() {
        return this.optionToBoolean(this.removeCacheMemoryOption);
    }

    public boolean getVerboseOption() {
        return this.optionToBoolean(this.verboseOption);
    }

    public boolean getNoNormOption() {
        return this.optionToBoolean(this.noNormOption);
    }

    public boolean getAllPearsonsOption() {
        return this.optionToBoolean(this.allPearsonsOption);
    }

    public boolean getNoFragNormOption() {
        return this.optionToBoolean(this.noFragNormOption);
    }

    public boolean getVersionOption() {
        return this.optionToBoolean(this.versionOption);
    }

    public boolean getRandomizePositionsOption() {
        return this.optionToBoolean(this.randomizePositionOption);
    }

    public boolean getThrowIntraFragOption() {
        return this.optionToBoolean(this.throwIntraFragOption);
    }

    protected String optionToString(CmdLineParser.Option option) {
        Object opt = this.getOptionValue(option);
        return opt == null ? null : opt.toString();
    }

    public String getFragmentOption() {
        return this.optionToString(this.fragmentOption);
    }

    public String getStatsOption() {
        return this.optionToString(this.statsOption);
    }

    public String getGraphOption() {
        return this.optionToString(this.graphOption);
    }

    public String getGenomeOption() {
        return this.optionToString(this.genomeIDOption);
    }

    public String getTmpdirOption() {
        return this.optionToString(this.tmpDirOption);
    }

    public String getMndIndexOption() {
        return this.optionToString(this.mndIndexOption);
    }

    public String getLigationOption() {
        return this.optionToString(this.ligationOption);
    }

    public String getShellOption() {
        return this.optionToString(this.shellOption);
    }

    public ReadPairFilter.Type getAlignmentOption() {
        int alignmentInt = this.optionToInt(this.alignmentFilterOption);
        if (alignmentInt == 0) {
            return null;
        }
        if (alignmentInt == 1) {
            return ReadPairFilter.Type.INNER;
        }
        if (alignmentInt == 2) {
            return ReadPairFilter.Type.OUTER;
        }
        if (alignmentInt == 3) {
            return ReadPairFilter.Type.LL;
        }
        if (alignmentInt == 4) {
            return ReadPairFilter.Type.RR;
        }
        if (alignmentInt == 5) {
            return ReadPairFilter.Type.TANDEM;
        }
        throw new IllegalArgumentException(String.format("alignment option %d not supported", alignmentInt));
    }

    protected int optionToInt(CmdLineParser.Option option) {
        Object opt = this.getOptionValue(option);
        return opt == null ? 0 : ((Number)opt).intValue();
    }

    public int getBlockCapacityOption() {
        return this.optionToInt(this.blockCapacityOption);
    }

    public int getCountThresholdOption() {
        return this.optionToInt(this.countThresholdOption);
    }

    public int getMapqThresholdOption() {
        return this.optionToInt(this.mapqOption);
    }

    public int getNearDiagonalOption() {
        return this.optionToInt(this.nearDiagonalOption);
    }

    public int getGenomeWideOption() {
        return this.optionToInt(this.genomeWideOption);
    }

    protected long optionToLong(CmdLineParser.Option option) {
        Object opt = this.getOptionValue(option);
        return opt == null ? 0L : ((Number)opt).longValue();
    }

    public long getRandomPositionSeedOption() {
        return this.optionToLong(this.randomSeedOption);
    }

    public int getNumThreads() {
        return this.optionToInt(this.threadNumOption);
    }

    public int getNumMatrixOperationThreads() {
        return this.optionToInt(this.matrixThreadNumOption);
    }

    public int getV9DepthBase() {
        return this.optionToInt(this.v9DepthBaseOption);
    }

    public int getInitType() {
        return this.optionToInt(this.initOption);
    }

    public int getRamSavePoint() {
        return this.optionToInt(this.ramSavePointOption);
    }

    protected double optionToDouble(CmdLineParser.Option option) {
        Object opt = this.getOptionValue(option);
        return opt == null ? -1.0 : ((Number)opt).doubleValue();
    }

    public double getScalingOption() {
        double opt = this.optionToDouble(this.hicFileScalingOption);
        if (opt > -1.0) {
            return opt;
        }
        return 1.0;
    }

    protected Set<String> optionToStringSet(CmdLineParser.Option option) {
        Object opt = this.getOptionValue(option);
        return opt == null ? null : new HashSet<String>(Arrays.asList(opt.toString().split(",")));
    }

    protected List<String> optionToStringList(CmdLineParser.Option option) {
        Object opt = this.getOptionValue(option);
        return opt == null ? null : new ArrayList<String>(Arrays.asList(opt.toString().split(",")));
    }

    public Set<String> getChromosomeSetOption() {
        return this.optionToStringSet(this.multipleChromosomesOption);
    }

    public List<String> getResolutionOption() {
        return this.optionToStringList(this.resolutionOption);
    }

    public Set<String> getRandomizePositionMaps() {
        return this.optionToStringSet(this.randomizePositionMapsOption);
    }

    protected List<Integer> optionToIntList(CmdLineParser.Option option) {
        Object opt = this.getOptionValue(option);
        if (opt == null) {
            return null;
        }
        String[] temp = opt.toString().split(",");
        ArrayList<Integer> options = new ArrayList<Integer>();
        for (String s : temp) {
            options.add(Integer.parseInt(s));
        }
        return options;
    }

    public List<Integer> getMultipleMapQOptions() {
        return this.optionToIntList(this.multipleMapQOption);
    }

    public List<NormalizationType> getAllNormalizationTypesOption() {
        NormalizationHandler normalizationHandler = new NormalizationHandler();
        List<String> normStrings = this.optionToStringList(this.normalizationTypeOption);
        if (normStrings == null || normStrings.size() < 1) {
            return normalizationHandler.getDefaultSetForHiCFileBuilding();
        }
        ArrayList<NormalizationType> normalizationTypes = new ArrayList<NormalizationType>();
        for (String normString : normStrings) {
            normalizationTypes.add(this.retrieveNormalization(normString, normalizationHandler));
        }
        return normalizationTypes;
    }

    protected NormalizationType retrieveNormalization(String norm, NormalizationHandler normalizationHandler) {
        if (norm == null || norm.length() < 1) {
            return null;
        }
        try {
            return normalizationHandler.getNormTypeFromString(norm);
        }
        catch (IllegalArgumentException error) {
            System.err.println("Normalization must be one of \"NONE\", \"VC\", \"VC_SQRT\", \"KR\", \"GW_KR\", \"GW_VC\", \"INTER_KR\", or \"INTER_VC\".");
            System.exit(7);
            return null;
        }
    }
}

