/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.clt;

import hic.tools.clt.JuiceboxCLT;
import hic.tools.clt.old.AddNorm;
import hic.tools.clt.old.BigWig;
import hic.tools.clt.old.BinToPairs;
import hic.tools.clt.old.Eigenvector;
import hic.tools.clt.old.LibraryComplexity;
import hic.tools.clt.old.PairsToBin;
import hic.tools.clt.old.Pearsons;
import hic.tools.clt.old.PreProcessing;
import hic.tools.clt.old.Statistics;
import hic.tools.clt.old.Sum;
import hic.tools.clt.old.TestNorm;

public class CLTFactory {
    private static final String[] commandLineToolUsages = new String[]{PreProcessing.getBasicUsage(), AddNorm.getBasicUsage(), Pearsons.getBasicUsage(), Eigenvector.getUsage(), Sum.getBasicUsage()};

    public static void generalUsage() {
        System.out.println("Juicer Tools Version 3.30.00");
        System.out.println("Usage:");
        for (String usage : commandLineToolUsages) {
            System.out.println("\t" + usage);
        }
        System.out.println("\t-h, --help print help");
        System.out.println("\t-v, --verbose verbose mode");
        System.out.println("\t-V, --version print version");
        System.out.println("Type juicer_tools <commandName> for more detailed usage instructions");
    }

    public static JuiceboxCLT getCLTCommand(String cmd) {
        if ((cmd = cmd.toLowerCase()).equals("pre")) {
            return new PreProcessing();
        }
        if (cmd.startsWith("sum")) {
            return new Sum();
        }
        if (cmd.startsWith("addnorm")) {
            return new AddNorm();
        }
        if (cmd.startsWith("test") && cmd.contains("norm")) {
            return new TestNorm();
        }
        if (cmd.equals("bigwig")) {
            return new BigWig();
        }
        if (cmd.equals("bintopairs")) {
            return new BinToPairs();
        }
        if (cmd.equals("pairstobin")) {
            return new PairsToBin();
        }
        if (cmd.equals("pearsons")) {
            return new Pearsons();
        }
        if (cmd.equals("eigenvector")) {
            return new Eigenvector();
        }
        if (cmd.contains("librarycomplexity")) {
            return new LibraryComplexity(cmd);
        }
        if (cmd.equals("statistics")) {
            return new Statistics();
        }
        return null;
    }
}

