/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import com.jidesoft.utils.RegistrationEvent;
import com.jidesoft.utils.RegistrationListener;
import com.jidesoft.utils.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class CacheMap<T, K> {
    private HashMap<Class<?>, Cache<K, T>> _cache = new HashMap();
    private K _defaultContext;
    protected List<RegistrationListener> listenerList = new ArrayList<RegistrationListener>();

    public CacheMap(K defaultContext) {
        this._defaultContext = defaultContext;
    }

    protected Cache<K, T> getCache(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Clazz cannot be null");
        }
        return this._cache.get(clazz);
    }

    public K[] getKeys(Class<?> clazz, K[] a) {
        Cache<K, T> cache2 = this.getCache(clazz);
        if (cache2 != null) {
            Set set = cache2.keySet();
            return set.toArray(a);
        }
        return a;
    }

    protected Cache<K, T> initCache(Class<?> clazz) {
        Cache<K, T> cache2 = this.getCache(clazz);
        if (cache2 != null) {
            return cache2;
        }
        cache2 = new Cache();
        this._cache.put(clazz, cache2);
        return cache2;
    }

    public void register(Class<?> clazz, T object, K context) {
        if (clazz == null) {
            throw new IllegalArgumentException("Parameter clazz cannot be null");
        }
        Cache<K, T> cache2 = this.initCache(clazz);
        cache2.setObject(context, object);
        this.fireRegistrationChanged(new RegistrationEvent(this, 3399, object, clazz, context));
    }

    public void unregister(Class<?> clazz, K context) {
        Cache<K, T> cache2 = this.getCache(clazz);
        if (cache2 != null) {
            T object = cache2.getObject(context);
            cache2.setObject(context, null);
            this.fireRegistrationChanged(new RegistrationEvent(this, 3400, object, clazz, context));
            if (cache2.size() == 0) {
                this._cache.remove(clazz);
            }
        }
    }

    public T getRegisteredObject(Class<?> clazz, K context) {
        if (clazz == null) {
            return null;
        }
        Cache<K, T> cache2 = this.getCache(clazz);
        if (cache2 == null || !cache2.containsKey(context)) {
            T object;
            Cache<K, T> cacheForClass;
            ArrayList classesToSearch = new ArrayList();
            classesToSearch.add(clazz);
            if (TypeUtils.isPrimitive(clazz)) {
                classesToSearch.add(TypeUtils.convertPrimitiveToWrapperType(clazz));
            } else if (TypeUtils.isPrimitiveWrapper(clazz)) {
                classesToSearch.add(TypeUtils.convertWrapperToPrimitiveType(clazz));
            }
            Class<?>[] interfaces = clazz.getInterfaces();
            classesToSearch.addAll(Arrays.asList(interfaces));
            Class<?> superClass = clazz;
            while (!superClass.isInterface() && (superClass = superClass.getSuperclass()) != null) {
                classesToSearch.add(superClass);
                interfaces = superClass.getInterfaces();
                classesToSearch.addAll(Arrays.asList(interfaces));
            }
            ArrayList interfacesToSearch = new ArrayList();
            for (Class clazz2 : classesToSearch) {
                if (!clazz2.isInterface()) continue;
                this.addInterface(clazz2, interfacesToSearch, classesToSearch);
            }
            classesToSearch.addAll(interfacesToSearch);
            classesToSearch.remove(Object.class);
            classesToSearch.add(Object.class);
            for (Class clazz3 : classesToSearch) {
                cacheForClass = this.getCache(clazz3);
                if (cacheForClass == null || (object = cacheForClass.getObject(context)) == null) continue;
                return object;
            }
            if (!this._defaultContext.equals(context)) {
                for (Class clazz4 : classesToSearch) {
                    cacheForClass = this.getCache(clazz4);
                    if (cacheForClass == null || (object = cacheForClass.getObject(this._defaultContext)) == null) continue;
                    return object;
                }
            }
        }
        if (cache2 != null) {
            T object = cache2.getObject(context);
            if (object == null && !this._defaultContext.equals(context)) {
                return this.getRegisteredObject(clazz, this._defaultContext);
            }
            if (object != null) {
                return object;
            }
        }
        return null;
    }

    private void addInterface(Class<?> anInterface, List<Class<?>> interfacesToSearch, List<Class<?>> classesToSearch) {
        if (anInterface != null) {
            Class<?>[] interfaces;
            for (Class<?> superInterface : interfaces = anInterface.getInterfaces()) {
                if (classesToSearch.contains(superInterface)) continue;
                interfacesToSearch.add(superInterface);
                this.addInterface(superInterface, interfacesToSearch, classesToSearch);
            }
        }
    }

    public T getMatchRegisteredObject(Class<?> clazz, K context) {
        T object;
        Cache<K, T> cache2;
        if (clazz == null) {
            return null;
        }
        if (context == null) {
            context = this._defaultContext;
        }
        if ((cache2 = this.getCache(clazz)) != null && (object = cache2.getObject(context)) != null) {
            return object;
        }
        return null;
    }

    public List<T> getValues() {
        ArrayList list = new ArrayList();
        Collection<Cache<K, T>> col = this._cache.values();
        for (Cache<K, T> o : col) {
            Collection col2 = o.values();
            for (Object o2 : col2) {
                if (list.contains(o2)) continue;
                list.add(o2);
            }
        }
        return list;
    }

    public void remove(Class<?> clazz) {
        Cache<Object, T> cache2 = this.getCache(clazz);
        if (cache2 != null) {
            Object[] keys2;
            for (Object context : keys2 = cache2.keySet().toArray()) {
                T object = cache2.getObject(context);
                cache2.setObject(context, null);
                this.fireRegistrationChanged(new RegistrationEvent(this, 3400, object, clazz, context));
            }
        }
        this._cache.remove(clazz);
    }

    public void clear() {
        this._cache.clear();
        this.fireRegistrationChanged(new RegistrationEvent(this, 3401));
    }

    public void addRegistrationListener(RegistrationListener l) {
        this.listenerList.add(l);
    }

    public void removeRegistrationListener(RegistrationListener l) {
        this.listenerList.remove(l);
    }

    public RegistrationListener[] getRegistrationListeners() {
        return this.listenerList.toArray(new RegistrationListener[this.listenerList.size()]);
    }

    public void fireRegistrationChanged(RegistrationEvent e) {
        for (int i = this.listenerList.size() - 2; i >= 0; i -= 2) {
            this.listenerList.get(i + 1).registrationChanged(e);
        }
    }

    static class Cache<K, T>
    extends HashMap<K, T> {
        private static final long serialVersionUID = 7764545350468551102L;

        Cache() {
        }

        public T getObject(K context) {
            return (T)this.get(context);
        }

        public void setObject(K context, T object) {
            if (object == null) {
                this.remove(context);
            } else {
                this.put(context, object);
            }
        }
    }
}

