/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.utils.ReflectionUtils;
import java.lang.reflect.Array;

public class EnumConverter
implements ObjectConverter {
    private String _name;
    private Object _default;
    private Class<?> _type;
    private Object[] _objects;
    private String[] _strings;
    private boolean _strict = true;
    private transient ConverterContext _context;

    public EnumConverter(Class<? extends Enum> enumType) {
        if (enumType == null || !enumType.isEnum()) {
            throw new IllegalArgumentException("To use this constructor, the type has to be an enum type.");
        }
        String name = enumType.getName();
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("Empty enum type name.");
        }
        int index = name.lastIndexOf("$");
        this._name = index >= 0 ? name.substring(index + 1) : name;
        this._type = enumType;
        try {
            Object values2 = ReflectionUtils.callStatic(enumType, "values", null, null);
            if (!values2.getClass().isArray()) {
                throw new IllegalArgumentException("Illegal enum type.");
            }
            int length = Array.getLength(values2);
            this._objects = new Object[length];
            this._strings = new String[length];
            for (int i = 0; i < length; ++i) {
                this._objects[i] = Array.get(values2, i);
                this._strings[i] = "" + this._objects[i];
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal enum type.");
        }
    }

    public EnumConverter(String name, Object[] values2, String[] strings) {
        this(name, values2[0] == null ? (values2.length > 1 ? values2[1].getClass() : Object.class) : values2[0].getClass(), values2, strings);
    }

    public EnumConverter(String name, Class<?> type, Object[] values2, String[] strings) {
        this(name, type, values2, strings, null);
    }

    public EnumConverter(String name, Class<?> type, Object[] objects, String[] strings, Object defaultValue) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("The \"name\" parameter cannot be null or empty. Please use a unique string to represent the name of the converter.");
        }
        this._name = name;
        if (objects == null) {
            throw new IllegalArgumentException("The \"objects\" parameter cannot be null.");
        }
        if (strings == null) {
            throw new IllegalArgumentException("The \"strings\" parameter cannot be null.");
        }
        if (strings.length != objects.length) {
            throw new IllegalArgumentException("The \"objects\" and \"strings\" parameters should have the same length.");
        }
        this._type = type;
        this._objects = objects;
        this._strings = strings;
        this._default = defaultValue;
    }

    public ConverterContext getContext() {
        if (this._context == null) {
            this._context = new ConverterContext(this._name);
        }
        return this._context;
    }

    @Override
    public String toString(Object object, ConverterContext context) {
        for (int i = 0; i < this._objects.length; ++i) {
            if ((this._objects[i] != null || object != null) && (this._objects[i] == null || !this._objects[i].equals(object)) || i >= this._strings.length) continue;
            return this._strings[i];
        }
        return this.isStrict() ? null : "" + object;
    }

    @Override
    public boolean supportToString(Object object, ConverterContext context) {
        return true;
    }

    @Override
    public Object fromString(String string, ConverterContext context) {
        for (int i = 0; i < this._strings.length; ++i) {
            if (!this._strings[i].equals(string) || i >= this._objects.length) continue;
            return this._objects[i];
        }
        return this.isStrict() ? this._default : string;
    }

    @Override
    public boolean supportFromString(String string, ConverterContext context) {
        return true;
    }

    public String getName() {
        return this._name;
    }

    public Class<?> getType() {
        return this._type;
    }

    public Object getDefault() {
        return this._default;
    }

    public Object[] getObjects() {
        return this._objects;
    }

    public Object[] getObjects(int[] indices) {
        Object[] objects = new Object[indices.length];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = this._objects[indices[i]];
        }
        return objects;
    }

    public String[] getStrings() {
        return this._strings;
    }

    public static String[] toStrings(Object[] values2) {
        return EnumConverter.toStrings(values2, null);
    }

    public static String[] toStrings(Object[] values2, ConverterContext converterContext) {
        String[] s = new String[values2.length];
        for (int i = 0; i < s.length; ++i) {
            s[i] = ObjectConverterManager.toString(values2[i], values2[i].getClass(), converterContext);
        }
        return s;
    }

    public boolean isStrict() {
        return this._strict;
    }

    public void setStrict(boolean strict) {
        this._strict = strict;
    }
}

