/*
 * Decompiled with CFR 0.152.
 */
package sfh.merger;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import sfh.merger.Merger;

public abstract class StatsMerger
extends Merger {
    public static int NUM_FIELDS = 28;
    private final long[] statistics = new long[NUM_FIELDS];

    @Override
    public void parse(String s) {
        StringTokenizer lines = new StringTokenizer(s, "\n");
        while (lines.hasMoreTokens()) {
            String current = lines.nextToken();
            this.processLine(current);
        }
    }

    protected long getStatistic(STATS_LABEL label) {
        return this.statistics[label.ordinal()];
    }

    protected void processLine(String current) {
        block10: {
            int key = this.parseLabel(current).ordinal();
            if (key == STATS_LABEL.IGNORE.ordinal()) {
                return;
            }
            String[] colonSplit = current.split(":");
            if (colonSplit.length == 2) {
                if (this.hasNA(colonSplit[1])) {
                    return;
                }
                String[] parenthesesSplit = colonSplit[1].split("\\(");
                if (key == STATS_LABEL.PAIR_PERCENTS.ordinal()) {
                    if (this.statistics[key] != -1L) {
                        this.statistics[key] = this.checkAll25(colonSplit[1]) ? 25L : -1L;
                    }
                } else {
                    try {
                        long value = Long.parseLong(parenthesesSplit[0].replaceAll(",", "").trim());
                        if (key == STATS_LABEL.CONVERGENCE.ordinal()) {
                            this.statistics[key] = Math.max(this.statistics[key], value);
                            break block10;
                        }
                        int n = key;
                        this.statistics[n] = this.statistics[n] + value;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                System.err.println("Incorrect form in original statistics attribute. Offending line:");
                System.err.println(current);
            }
        }
    }

    private boolean checkAll25(String s) {
        int end;
        int start = s.length();
        return start - (end = s.replaceAll("25%", "").length()) == 12;
    }

    private boolean hasNA(String s) {
        String na = "N/A";
        return s.toLowerCase().contains(na.toLowerCase());
    }

    protected STATS_LABEL parseLabel(String s) {
        if (StatsMerger.containsIgnoreCase(s, "No chimera found:")) {
            return STATS_LABEL.NO_CHIMERA;
        }
        if (StatsMerger.containsIgnoreCase(s, "3 or more alignments")) {
            return STATS_LABEL.THREE_PLUS;
        }
        if (StatsMerger.containsIgnoreCase(s, "Ligation Motif Present:")) {
            return STATS_LABEL.LIGATION_MOTIF;
        }
        if (StatsMerger.containsIgnoreCase(s, "Total Unique:")) {
            return STATS_LABEL.TOTAL_UNIQUE;
        }
        if (StatsMerger.containsIgnoreCase(s, "Total Duplicates:")) {
            return STATS_LABEL.TOTAL_DUPS;
        }
        if (StatsMerger.containsIgnoreCase(s, "Library Complexity")) {
            return STATS_LABEL.IGNORE;
        }
        if (StatsMerger.containsIgnoreCase(s, "Intra-fragment Reads:")) {
            return STATS_LABEL.INTRA_FRAG_READS;
        }
        if (StatsMerger.containsIgnoreCase(s, "Below MAPQ Threshold:")) {
            return STATS_LABEL.BELOW_MAPQ;
        }
        if (StatsMerger.containsIgnoreCase(s, "Hi-C Contacts:")) {
            return STATS_LABEL.HIC_CONTACTS;
        }
        if (StatsMerger.containsIgnoreCase(s, "3' Bias (Long Range):")) {
            return STATS_LABEL.THREE_BIAS;
        }
        if (StatsMerger.containsIgnoreCase(s, "Pair Type %(L-I-O-R):")) {
            return STATS_LABEL.PAIR_PERCENTS;
        }
        if (StatsMerger.containsIgnoreCase(s, "L-I-O-R Convergence:")) {
            return STATS_LABEL.CONVERGENCE;
        }
        if (StatsMerger.containsIgnoreCase(s, "Inter-chromosomal:")) {
            return STATS_LABEL.INTER;
        }
        if (StatsMerger.containsIgnoreCase(s, "Intra-chromosomal:")) {
            return STATS_LABEL.INTRA;
        }
        if (StatsMerger.containsIgnoreCase(s, "Short Range (<20Kb):")) {
            return STATS_LABEL.IGNORE;
        }
        if (StatsMerger.containsIgnoreCase(s, "<500BP:")) {
            return STATS_LABEL.FIVE_HUNDRED_BP;
        }
        if (StatsMerger.containsIgnoreCase(s, "500BP-5kB:")) {
            return STATS_LABEL.FIVE_KB;
        }
        if (StatsMerger.containsIgnoreCase(s, "5kB-20kB:")) {
            return STATS_LABEL.TWENTY_KB;
        }
        if (StatsMerger.containsIgnoreCase(s, "Long Range (>20Kb):")) {
            return STATS_LABEL.LONG_RANGE;
        }
        return STATS_LABEL.IGNORE;
    }

    protected void write(BufferedWriter statsOut, String description, STATS_LABEL valType, long denom, long denom2) throws IOException {
        long value = this.statistics[valType.ordinal()];
        if (value > 0L) {
            if (denom > 0L) {
                if (denom2 > 0L) {
                    statsOut.write(description + value + " (" + this.percent(value, denom) + " / " + this.percent(value, denom2) + ")\n");
                } else {
                    statsOut.write(description + value + " (" + this.percent(value, denom) + ")\n");
                }
            } else {
                statsOut.write(description + value + "\n");
            }
        }
    }

    private String percent(long num, long total) {
        return String.format("%.2f", Float.valueOf((float)num * 100.0f / (float)total)) + "%";
    }

    public static enum STATS_LABEL {
        TOTAL_SEQ,
        UNMAPPED,
        TWO_ALIGN,
        TWO_ALIGN_A,
        TWO_ALIGN_B,
        ONE_ALIGN,
        ONE_UNIQUE,
        ONE_DUPS,
        TWO_UNIQUE,
        TWO_DUPS,
        IGNORE,
        NO_CHIMERA,
        THREE_PLUS,
        LIGATION_MOTIF,
        TOTAL_UNIQUE,
        TOTAL_DUPS,
        INTRA_FRAG_READS,
        BELOW_MAPQ,
        HIC_CONTACTS,
        THREE_BIAS,
        PAIR_PERCENTS,
        CONVERGENCE,
        INTER,
        INTRA,
        FIVE_HUNDRED_BP,
        FIVE_KB,
        TWENTY_KB,
        LONG_RANGE;

    }
}

