/*
 * Decompiled with CFR 0.152.
 */
package sfh.merger;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;
import sfh.merger.Merger;

public class GraphsMerger
extends Merger {
    private final long[] A = new long[2000];
    private final long[][] B = new long[3][200];
    private final long[][] D = new long[4][100];
    private final long[] x = new long[100];

    @Override
    public void parse(String s) {
        Scanner scanner = new Scanner(s);
        try {
            this.skipUntilNextArray(scanner);
            this.addTo1DArray(this.A, scanner);
            this.skipUntilNextArray(scanner);
            this.addTo2DArray(this.B, scanner);
            this.skipUntilNextArray(scanner);
            this.addTo2DArray(this.D, scanner);
            this.skipUntilNextArray(scanner);
            for (int idx = 0; idx < this.x.length; ++idx) {
                long newX = scanner.nextLong();
                if (this.x[idx] > 0L && this.x[idx] != newX) {
                    System.err.println("X mismatch error? " + this.x[idx] + " - " + newX);
                }
                this.x[idx] = newX;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void printToMergedFile(String filename) {
        try {
            BufferedWriter histWriter = new BufferedWriter(new FileWriter(filename));
            histWriter.write("A = [\n");
            this.write1DArray(this.A, histWriter);
            histWriter.write("\n];\n");
            histWriter.write("B = [\n");
            this.write2DArray(this.B, histWriter);
            histWriter.write("\n];\n");
            histWriter.write("D = [\n");
            this.write2DArray(this.D, histWriter);
            histWriter.write("\n];");
            histWriter.write("x = [\n");
            this.write1DArray(this.x, histWriter);
            histWriter.write("\n];\n");
            histWriter.close();
        }
        catch (IOException error) {
            error.printStackTrace();
        }
    }

    private void addTo1DArray(long[] arr, Scanner scanner) {
        int idx = 0;
        while (idx < arr.length) {
            int n = idx++;
            arr[n] = arr[n] + scanner.nextLong();
        }
    }

    private void write1DArray(long[] arr, BufferedWriter histWriter) throws IOException {
        for (long tmp : arr) {
            histWriter.write(tmp + " ");
        }
    }

    private void addTo2DArray(long[][] arr, Scanner scanner) {
        int numRows = arr.length;
        int len = arr[0].length;
        for (int idx = 0; idx < len; ++idx) {
            for (int r = 0; r < numRows; ++r) {
                try {
                    long[] lArray = arr[r];
                    int n = idx;
                    lArray[n] = lArray[n] + scanner.nextLong();
                    continue;
                }
                catch (Exception e) {
                    System.err.println(scanner.next());
                    e.printStackTrace();
                }
            }
        }
    }

    private void write2DArray(long[][] arr, BufferedWriter histWriter) throws IOException {
        int numRows = arr.length;
        int len = arr[0].length;
        for (int idx = 0; idx < len; ++idx) {
            String s = "" + arr[0][idx];
            for (int r = 1; r < numRows; ++r) {
                s = s + " " + arr[r][idx];
            }
            histWriter.write(s + "\n");
        }
    }

    private void skipUntilNextArray(Scanner scanner) {
        while (!scanner.next().equals("[")) {
        }
    }
}

