/*
 * Decompiled with CFR 0.152.
 */
package sfh;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javastraw.reader.Dataset;
import javastraw.tools.HiCFileTools;
import sfh.StatsUtils;
import sfh.merger.GraphsMerger;
import sfh.merger.Merger;
import sfh.merger.PairedAlignmentStatsMerger;
import sfh.merger.SingleAlignmentStatsMerger;

public class MergeStats {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: java -jar stats-from-hic.jar <inter_stem> <in.hic> [... in2.hic in3.hic]");
            System.exit(4);
        }
        boolean isHIC = args[1].toLowerCase().endsWith(".hic");
        boolean isHistogram = args[1].toLowerCase().endsWith("_hists.m");
        boolean isInter = args[1].toLowerCase().endsWith(".txt") && args[1].toLowerCase().contains("inter");
        ArrayList<String> statsList = new ArrayList<String>();
        ArrayList<String> graphsList = new ArrayList<String>();
        if (isHIC) {
            for (int i = 1; i < args.length; ++i) {
                Dataset ds = HiCFileTools.extractDatasetForCLT(args[i], false, false);
                statsList.add(ds.getStatistics());
                graphsList.add(ds.getGraphs());
            }
        } else if (isHistogram) {
            MergeStats.populateList(graphsList, args);
        } else if (isInter) {
            MergeStats.populateList(statsList, args);
        } else {
            MergeStats.printUsageAndExit(6);
        }
        if (statsList.size() > 0) {
            boolean isSingleAlignment = MergeStats.confirmAllSameAlignment(statsList);
            if (isSingleAlignment) {
                StatsUtils.merge(statsList, new SingleAlignmentStatsMerger(), args[0] + ".txt");
            } else {
                StatsUtils.merge(statsList, new PairedAlignmentStatsMerger(), args[0] + ".txt");
            }
        }
        if (graphsList.size() > 0) {
            StatsUtils.merge(graphsList, new GraphsMerger(), args[0] + "_hists.m");
        }
    }

    private static void populateList(List<String> filesList, String[] args) {
        for (int i = 1; i < args.length; ++i) {
            try {
                filesList.add(MergeStats.readFileIntoString(args[i]));
                continue;
            }
            catch (Exception e) {
                System.err.println("Unable to parse file: " + args[i]);
                e.printStackTrace();
                System.exit(9);
            }
        }
    }

    private static String readFileIntoString(String filepath) throws FileNotFoundException {
        BufferedReader reader = new BufferedReader(new FileReader(filepath));
        return reader.lines().collect(Collectors.joining("\n"));
    }

    private static void printUsageAndExit(int code) {
        System.err.println("Usage: java -jar merge-stats.jar <stem> <inter.hic> [inter2.hic ...]");
        System.err.println("Usage: java -jar merge-stats.jar <stem> <inter.txt> [inter2.txt ...]");
        System.err.println("Usage: java -jar merge-stats.jar <stem> <inter_hists.m> [inter2_hists.m ...]");
        System.err.println("Stem: \"inter\" (or \"inter_30\") if inputs are mapq1 (or mapq30)");
        System.exit(code);
    }

    private static boolean confirmAllSameAlignment(List<String> statsList) {
        boolean hasSingleAlignment = false;
        boolean hasPairedAlignment = false;
        for (String s : statsList) {
            hasSingleAlignment |= Merger.containsIgnoreCase(s, "Read type: Single End");
            hasPairedAlignment |= Merger.containsIgnoreCase(s, "Read type: Paired End");
        }
        if (hasSingleAlignment && hasPairedAlignment) {
            System.err.println("Cannot mix single-end and paired-end files together");
            System.exit(9);
        }
        return hasSingleAlignment;
    }
}

