/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.util.Iterator;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.VcfOrBcf;

@CommandLineProgramProperties(usage="Splits an input VCF or BCF file into two VCF files, one for indel records and one for SNPs. Theheaders of the two output files will be identical. An index file is created and asequence dictionary is required by default.", usageShort="Splits an input VCF or BCF file into two VCF or BCF files", programGroup=VcfOrBcf.class)
public class SplitVcfs
extends CommandLineProgram {
    @Option(shortName="I", doc="The VCF or BCF input file")
    public File INPUT;
    @Option(doc="The VCF or BCF file to which SNP records should be written. The file format is determined by file extension.")
    public File SNP_OUTPUT;
    @Option(doc="The VCF or BCF file to which indel records should be written. The file format is determined by file extension.")
    public File INDEL_OUTPUT;
    @Option(shortName="D", doc="The index sequence dictionary to use instead of the sequence dictionaries in the input files", optional=true)
    public File SEQUENCE_DICTIONARY;
    @Option(doc="If true an exception will be thrown if an event type other than SNP or indel is encountered")
    public Boolean STRICT = true;
    private final Log log = Log.getInstance(SplitVcfs.class);

    public static void main(String[] argv) {
        new SplitVcfs().instanceMainWithExit(argv);
    }

    public SplitVcfs() {
        this.CREATE_INDEX = true;
    }

    @Override
    protected int doWork() {
        SAMSequenceDictionary sequenceDictionary;
        IOUtil.assertFileIsReadable(this.INPUT);
        ProgressLogger progress = new ProgressLogger(this.log, 10000);
        VCFFileReader fileReader = new VCFFileReader(this.INPUT);
        VCFHeader fileHeader = fileReader.getFileHeader();
        SAMSequenceDictionary sAMSequenceDictionary = sequenceDictionary = this.SEQUENCE_DICTIONARY != null ? SAMFileReader.getSequenceDictionary(this.SEQUENCE_DICTIONARY) : fileHeader.getSequenceDictionary();
        if (this.CREATE_INDEX.booleanValue() && sequenceDictionary == null) {
            throw new PicardException("A sequence dictionary must be available (either through the input file or by setting it explicitly) when creating indexed output.");
        }
        VariantContextWriterBuilder builder = new VariantContextWriterBuilder().setReferenceDictionary(sequenceDictionary).clearOptions();
        if (this.CREATE_INDEX.booleanValue()) {
            builder.setOption(Options.INDEX_ON_THE_FLY);
        }
        VariantContextWriter snpWriter = builder.setOutputFile(this.SNP_OUTPUT).build();
        VariantContextWriter indelWriter = builder.setOutputFile(this.INDEL_OUTPUT).build();
        snpWriter.writeHeader(fileHeader);
        indelWriter.writeHeader(fileHeader);
        int incorrectVariantCount = 0;
        Iterator iterator2 = fileReader.iterator();
        while (iterator2.hasNext()) {
            VariantContext context = (VariantContext)iterator2.next();
            if (context.isIndel()) {
                indelWriter.add(context);
            } else if (context.isSNP()) {
                snpWriter.add(context);
            } else {
                if (this.STRICT.booleanValue()) {
                    throw new IllegalStateException("Found a record with type " + context.getType().name());
                }
                ++incorrectVariantCount;
            }
            progress.record(context.getChr(), context.getStart());
        }
        if (incorrectVariantCount > 0) {
            this.log.debug("Found " + incorrectVariantCount + " records that didn't match SNP or INDEL");
        }
        CloserUtil.close(iterator2);
        CloserUtil.close(fileReader);
        snpWriter.close();
        indelWriter.close();
        return 0;
    }
}

