/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Intervals;

@CommandLineProgramProperties(usage="Writes an interval list based on splitting the reference by Ns.", usageShort="Writes an interval list based on splitting the reference by Ns", programGroup=Intervals.class)
public class ScatterIntervalsByNs
extends CommandLineProgram {
    @Option(shortName="R", doc="Reference sequence to use.")
    public File REFERENCE;
    @Option(shortName="O", doc="Output file for interval list.")
    public File OUTPUT;
    @Option(shortName="OT", doc="Type of intervals to output.", optional=true)
    public OutputType OUTPUT_TYPE = OutputType.BOTH;
    @Option(shortName="N", doc="Maximal number of contiguous N bases to tolerate, thereby continuing the current ACGT interval.", optional=true)
    public int MAX_TO_MERGE = 1;
    static final String ACGTmer = "ACGTmer";
    static final String Nmer = "Nmer";
    private static final Log log = Log.getInstance(ScatterIntervalsByNs.class);
    final ProgressLogger locusProgress = new ProgressLogger(log, 10000000, "examined", "loci");
    final ProgressLogger intervalProgress = new ProgressLogger(log, 10, "found", "intervals");

    public static void main(String[] args) {
        new ScatterIntervalsByNs().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable(this.REFERENCE);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        ReferenceSequenceFile refFile = ReferenceSequenceFileFactory.getReferenceSequenceFile(this.REFERENCE, true);
        IntervalList intervals = ScatterIntervalsByNs.segregateReference(refFile, this.MAX_TO_MERGE);
        log.info(String.format("Found %d intervals in %d loci during %s seconds", this.intervalProgress.getCount(), this.locusProgress.getCount(), this.locusProgress.getElapsedSeconds()));
        IntervalList outputIntervals = new IntervalList(intervals.getHeader().clone());
        log.info(String.format("Collecting requested type of intervals (%s)", new Object[]{this.OUTPUT_TYPE}));
        for (Interval i : intervals.getIntervals()) {
            if (!this.OUTPUT_TYPE.accepts(i.getName()).booleanValue()) continue;
            outputIntervals.add(i);
        }
        log.info("Writing Intervals.");
        outputIntervals.write(this.OUTPUT);
        log.info(String.format("Execution ending. Total time %d seconds", this.locusProgress.getElapsedSeconds()));
        return 0;
    }

    public static IntervalList segregateReference(ReferenceSequenceFile refFile, int maxNmerToMerge) {
        LinkedList<Interval> preliminaryIntervals = new LinkedList<Interval>();
        SAMFileHeader header = new SAMFileHeader();
        header.setSequenceDictionary(refFile.getSequenceDictionary());
        header.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        IntervalList finalIntervals = new IntervalList(header);
        for (SAMSequenceRecord rec : refFile.getSequenceDictionary().getSequences()) {
            ReferenceSequence ref = refFile.getSequence(rec.getSequenceName());
            byte[] bytes2 = ref.getBases();
            StringUtil.toUpperCase(bytes2);
            boolean nBlockIsOpen = bytes2[0] == 78;
            int start = 0;
            for (int i = 0; i < bytes2.length; ++i) {
                boolean currentBaseIsN;
                boolean bl = currentBaseIsN = bytes2[i] == 78;
                if (nBlockIsOpen == currentBaseIsN) continue;
                preliminaryIntervals.add(new Interval(rec.getSequenceName(), start + 1, i, false, nBlockIsOpen ? Nmer : ACGTmer));
                start = i;
                nBlockIsOpen = !nBlockIsOpen;
            }
            preliminaryIntervals.add(new Interval(rec.getSequenceName(), start + 1, bytes2.length, false, nBlockIsOpen ? Nmer : ACGTmer));
        }
        while (!preliminaryIntervals.isEmpty()) {
            if (preliminaryIntervals.size() >= 3 && ((Interval)preliminaryIntervals.get(0)).getName() == ACGTmer && ((Interval)preliminaryIntervals.get(1)).getName() == Nmer && ((Interval)preliminaryIntervals.get(2)).getName() == ACGTmer && ((Interval)preliminaryIntervals.get(0)).abuts((Interval)preliminaryIntervals.get(1)) && ((Interval)preliminaryIntervals.get(1)).abuts((Interval)preliminaryIntervals.get(2)) && ((Interval)preliminaryIntervals.get(1)).length() <= maxNmerToMerge) {
                Interval temp = new Interval(((Interval)preliminaryIntervals.get(0)).getSequence(), ((Interval)preliminaryIntervals.get(0)).getStart(), ((Interval)preliminaryIntervals.get(2)).getEnd(), false, ACGTmer);
                for (int i = 0; i < 3; ++i) {
                    preliminaryIntervals.remove(0);
                }
                preliminaryIntervals.add(0, temp);
                continue;
            }
            finalIntervals.add((Interval)preliminaryIntervals.remove(0));
        }
        return finalIntervals;
    }

    private static enum OutputType {
        N("Nmer"),
        ACGT("ACGTmer"),
        BOTH("Nmer", "ACGTmer");

        private final Set acceptedTypes = new HashSet();

        public Boolean accepts(String string) {
            return this.acceptedTypes.contains(string);
        }

        private OutputType(String ... strings) {
            Collections.addAll(this.acceptedTypes, strings);
        }
    }
}

