/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.directed;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SequenceUtil;
import java.io.File;
import java.util.List;
import java.util.Set;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.directed.CalculateHsMetrics;
import picard.analysis.directed.TargetMetricsCollector;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.Option;
import picard.metrics.MultiLevelCollector;
import picard.metrics.MultilevelMetrics;

public abstract class CollectTargetedMetrics<METRIC extends MultilevelMetrics, COLLECTOR extends TargetMetricsCollector<METRIC>>
extends CommandLineProgram {
    private static final Log log = Log.getInstance(CalculateHsMetrics.class);
    @Option(shortName="TI", doc="An interval list file that contains the locations of the targets.", minElements=1)
    public List<File> TARGET_INTERVALS;
    @Option(shortName="I", doc="An aligned SAM or BAM file.")
    public File INPUT;
    @Option(shortName="O", doc="The output file to write the metrics to.")
    public File OUTPUT;
    @Option(shortName="LEVEL", doc="The level(s) at which to accumulate metrics.")
    public Set<MetricAccumulationLevel> METRIC_ACCUMULATION_LEVEL = CollectionUtil.makeSet(MetricAccumulationLevel.ALL_READS);
    @Option(shortName="R", optional=true, doc="The reference sequence aligned to.")
    public File REFERENCE_SEQUENCE;
    @Option(optional=true, doc="An optional file to output per target coverage information to.")
    public File PER_TARGET_COVERAGE;

    protected abstract IntervalList getProbeIntervals();

    protected abstract String getProbeSetName();

    protected abstract COLLECTOR makeCollector(Set<MetricAccumulationLevel> var1, List<SAMReadGroupRecord> var2, ReferenceSequenceFile var3, File var4, IntervalList var5, IntervalList var6, String var7);

    @Override
    protected int doWork() {
        for (File targetInterval : this.TARGET_INTERVALS) {
            IOUtil.assertFileIsReadable(targetInterval);
        }
        IOUtil.assertFileIsReadable(this.INPUT);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        if (this.PER_TARGET_COVERAGE != null) {
            IOUtil.assertFileIsWritable(this.PER_TARGET_COVERAGE);
        }
        SamReader reader = SamReaderFactory.makeDefault().open(this.INPUT);
        IntervalList targetIntervals = IntervalList.fromFiles(this.TARGET_INTERVALS);
        SequenceUtil.assertSequenceDictionariesEqual(reader.getFileHeader().getSequenceDictionary(), targetIntervals.getHeader().getSequenceDictionary());
        SequenceUtil.assertSequenceDictionariesEqual(reader.getFileHeader().getSequenceDictionary(), this.getProbeIntervals().getHeader().getSequenceDictionary());
        ReferenceSequenceFile ref = null;
        if (this.REFERENCE_SEQUENCE != null) {
            IOUtil.assertFileIsReadable(this.REFERENCE_SEQUENCE);
            ref = ReferenceSequenceFileFactory.getReferenceSequenceFile(this.REFERENCE_SEQUENCE);
            SequenceUtil.assertSequenceDictionariesEqual(reader.getFileHeader().getSequenceDictionary(), ref.getSequenceDictionary(), this.INPUT, this.REFERENCE_SEQUENCE);
        }
        COLLECTOR collector = this.makeCollector(this.METRIC_ACCUMULATION_LEVEL, reader.getFileHeader().getReadGroups(), ref, this.PER_TARGET_COVERAGE, targetIntervals, this.getProbeIntervals(), this.getProbeSetName());
        ProgressLogger progress = new ProgressLogger(log);
        for (SAMRecord record : reader) {
            ((MultiLevelCollector)collector).acceptRecord(record, null);
            progress.record(record);
        }
        MetricsFile metrics = this.getMetricsFile();
        ((MultiLevelCollector)collector).finish();
        ((MultiLevelCollector)collector).addAllLevelsToFile(metrics);
        metrics.write(this.OUTPUT);
        return 0;
    }

    static String renderProbeNameFromFile(File probeIntervalFile) {
        String name = probeIntervalFile.getName();
        int firstPeriodIndex = name.indexOf(46);
        if (firstPeriodIndex == -1) {
            return name;
        }
        return name.substring(0, firstPeriodIndex);
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.PER_TARGET_COVERAGE != null && (this.METRIC_ACCUMULATION_LEVEL.size() != 1 || this.METRIC_ACCUMULATION_LEVEL.iterator().next() != MetricAccumulationLevel.ALL_READS)) {
            return new String[]{"PER_TARGET_COVERAGE can be specified only when METRIC_ACCUMULATION_LEVEL is set to ALL_READS."};
        }
        if (this.PER_TARGET_COVERAGE != null && this.REFERENCE_SEQUENCE == null) {
            return new String[]{"Must supply REFERENCE_SEQUENCE when supplying PER_TARGET_COVERAGE"};
        }
        return super.customCommandLineValidation();
    }
}

