/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.variant.util;

import java.io.BufferedReader;
import java.io.IOException;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.event.TrackGroupEvent;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.util.ParsingUtils;

public class PedigreeUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseTrioFile(String path) throws IOException {
        try (BufferedReader reader = null;){
            String nextLine;
            reader = ParsingUtils.openBufferedReader(path);
            int familyNumber = 1;
            while ((nextLine = reader.readLine()) != null) {
                String[] tokens2 = nextLine.split("\\s+");
                if (tokens2.length != 3) continue;
                String family = String.valueOf(familyNumber);
                for (String member : tokens2) {
                    AttributeManager.getInstance().addAttribute(member, "Family", family);
                }
                String child = tokens2[0];
                String father = tokens2[1];
                String mother = tokens2[2];
                AttributeManager.getInstance().addAttribute(child, "Member", "child");
                AttributeManager.getInstance().addAttribute(child, "Relation", "child");
                AttributeManager.getInstance().addAttribute(father, "Member", "father");
                AttributeManager.getInstance().addAttribute(father, "Relation", "parent");
                AttributeManager.getInstance().addAttribute(mother, "Member", "mother");
                AttributeManager.getInstance().addAttribute(mother, "Relation", "parent");
                ++familyNumber;
            }
            IGVEventBus.getInstance().post(new TrackGroupEvent(null));
        }
    }
}

