/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.HttpUtils;

public class RuntimeUtils {
    private static Logger log = Logger.getLogger(RuntimeUtils.class);

    public static long getAvailableMemory() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        return freeMemory + (maxMemory - allocatedMemory);
    }

    public static double getAvailableMemoryFraction() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        return (double)(freeMemory + (maxMemory - allocatedMemory)) / (double)maxMemory;
    }

    public static Process startExternalProcess(String[] msg, String[] envp, File dir) throws IOException {
        Process pr = Runtime.getRuntime().exec(msg, envp, dir);
        RuntimeUtils.startErrorReadingThread(pr);
        return pr;
    }

    private static Process startErrorReadingThread(Process pr) {
        final BufferedReader err = new BufferedReader(new InputStreamReader(pr.getErrorStream()));
        Thread runnable = new Thread(){
            private boolean messageDisplayed = false;

            @Override
            public void run() {
                try {
                    String line;
                    while ((line = err.readLine()) != null) {
                        log.error(line);
                        if (this.messageDisplayed || !line.toLowerCase().contains("error")) continue;
                        MessageUtils.showMessage(line + "<br>See igv.log for more details");
                        this.messageDisplayed = true;
                    }
                    err.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), e);
                    throw new RuntimeException(e);
                }
            }
        };
        runnable.start();
        return pr;
    }

    @Deprecated
    public static String executeShellCommand(String cmd, String[] envp, File dir) throws IOException {
        return RuntimeUtils.executeShellCommand(new String[]{cmd}, envp, dir);
    }

    public static String executeShellCommand(String[] cmd, String[] envp, File dir) throws IOException {
        return RuntimeUtils.executeShellCommand(cmd, envp, dir, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeShellCommand(String[] cmd, String[] envp, File dir, boolean waitFor) throws IOException {
        Process pr = RuntimeUtils.startExternalProcess(cmd, envp, dir);
        if (waitFor) {
            try {
                pr.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        InputStream inputStream = null;
        String line = "";
        try {
            inputStream = pr.getInputStream();
            BufferedReader buf = new BufferedReader(new InputStreamReader(inputStream));
            StringWriter writer = new StringWriter();
            PrintWriter pw = new PrintWriter(writer);
            while ((line = buf.readLine()) != null) {
                pw.println(line);
            }
            pw.close();
            String string = writer.toString();
            return string;
        }
        finally {
            OutputStream os;
            if (inputStream != null) {
                inputStream.close();
            }
            if ((os = pr.getOutputStream()) != null) {
                os.close();
            }
        }
    }

    private static URL[] filesToURLs(File[] files) {
        URL[] urls = new URL[files.length];
        for (int pp = 0; pp < files.length; ++pp) {
            try {
                urls[pp] = HttpUtils.createURL("file://" + files[0].getAbsolutePath());
                continue;
            }
            catch (MalformedURLException e) {
                log.error(e);
            }
        }
        return urls;
    }

    private static URL[] addBuiltinURLs(URL[] libURLs) {
        File[] builtin_paths = RuntimeUtils.getPluginJars();
        URL[] builtin_urls = RuntimeUtils.filesToURLs(builtin_paths);
        ArrayList<URL> outURLs = new ArrayList<URL>(Arrays.asList(libURLs != null ? libURLs : new URL[]{}));
        outURLs.addAll(Arrays.asList(builtin_urls));
        return outURLs.toArray(new URL[outURLs.size()]);
    }

    private static URL[] getClassURLs(URL[] libURLs) {
        return RuntimeUtils.addBuiltinURLs(libURLs);
    }

    public static Class loadClassForName(String className, URL[] libURLs) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz != null) {
            return clazz;
        }
        URL[] allURLs = RuntimeUtils.getClassURLs(libURLs);
        URLClassLoader loader = URLClassLoader.newInstance(allURLs, ClassLoader.getSystemClassLoader());
        clazz = loader.loadClass(className);
        return clazz;
    }

    public static Object loadInstanceForName(String className, URL[] libURLs) throws IllegalAccessException, InstantiationException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Class clazz = RuntimeUtils.loadClassForName(className, libURLs);
        Constructor constructor = clazz.getConstructor(new Class[0]);
        return constructor.newInstance(new Object[0]);
    }

    public static File[] getPluginJars() {
        File builtinDir = new File(DirectoryManager.getIgvDirectory(), "plugins/");
        File[] pluginJars = builtinDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jar");
            }
        });
        if (pluginJars == null) {
            pluginJars = new File[]{};
        }
        return pluginJars;
    }

    public static void loadPluginJars() {
        File[] pluginJars = RuntimeUtils.getPluginJars();
        if (pluginJars != null) {
            for (File jar : pluginJars) {
                RuntimeUtils.loadLibrary(jar);
            }
        }
    }

    private static boolean loadLibrary(File jar) {
        try {
            URLClassLoader loader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            URL url = jar.toURI().toURL();
            for (URL it : Arrays.asList(loader.getURLs())) {
                if (!it.equals(url)) continue;
                return false;
            }
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)loader, url);
            return true;
        }
        catch (Exception e) {
            log.warn("Error loading jar: " + e.getMessage());
            return false;
        }
    }
}

