/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class ByteConverter {
    public static float[] convertBytesToFloats(byte[] bytes2) {
        try {
            int nFloats = bytes2.length / 4;
            float[] floats = new float[nFloats];
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes2));
            for (int i = 0; i < nFloats; ++i) {
                if (dis.available() < 4) continue;
                floats[i] = dis.readFloat();
            }
            dis.close();
            return floats;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public static int[] convertBytesToInts(byte[] bytes2) {
        try {
            int nInts = bytes2.length / 4;
            int[] ints = new int[nInts];
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes2));
            for (int i = 0; i < nInts; ++i) {
                if (dis.available() < 4) continue;
                ints[i] = dis.readInt();
            }
            dis.close();
            return ints;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public static long[] convertBytesToLongs(byte[] bytes2) {
        try {
            int nLongs = bytes2.length / 8;
            long[] longs = new long[nLongs];
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes2));
            for (int i = 0; i < nLongs; ++i) {
                if (dis.available() < 8) continue;
                longs[i] = dis.readLong();
            }
            dis.close();
            return longs;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public static String[] convertBytesToStrings(byte[] bytes2, int nChars) {
        try {
            int nStrings = bytes2.length / (nChars * 2);
            String[] strings = new String[nStrings];
            byte[] stringBytes = new byte[nChars * 2];
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes2));
            for (int i = 0; i < nStrings; ++i) {
                if (dis.available() < nChars * 2) continue;
                dis.read(stringBytes);
                strings[i] = new String(stringBytes, "UTF-16BE").trim();
            }
            return strings;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }
}

