/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.broad.igv.track.Track;
import org.broad.igv.ui.FilterComponent;
import org.broad.igv.ui.TrackFilter;
import org.broad.igv.ui.TrackFilterComponent;
import org.broad.igv.util.FilterElement;

public class TrackFilterPane
extends JPanel {
    private final int vgap;
    private boolean matchAll = true;
    private TrackFilter filter;
    protected List<String> itemList;
    protected String itemListLabel;
    private Component[] filterComponentBackup;

    public TrackFilterPane(List<String> items, String itemListLabel, TrackFilter filter) {
        this.setBackground(new Color(255, 255, 255));
        this.setMinimumSize(new Dimension(500, 100));
        this.vgap = 5;
        this.setLayout(new FlowLayout(0, 0, this.vgap));
        this.itemList = new ArrayList<String>(items);
        this.itemListLabel = itemListLabel;
        if (filter != null) {
            this.filter = filter;
            FilterComponent filterComponent = null;
            Iterator iterator2 = filter.getFilterElements();
            while (iterator2.hasNext()) {
                FilterElement element = (FilterElement)iterator2.next();
                filterComponent = this.createFilterComponent(this, itemListLabel, this.itemList, element);
                filterComponent.displayMoreButton(false);
                this.add(filterComponent);
            }
            if (filterComponent != null) {
                filterComponent.displayMoreButton(true);
            }
        } else {
            this.filter = this.createNewFilter();
        }
        this.backup();
        if (this.filter.isEmpty()) {
            this.more();
        }
    }

    public TrackFilter createNewFilter() {
        String name = "";
        return new TrackFilter(name, null);
    }

    public TrackFilter getFilter() {
        return this.filter;
    }

    public void clearTracks() {
        this.getFilter().clearTracks();
    }

    public void addTracks(List<Track> tracks) {
        this.getFilter().addTracks(tracks);
    }

    public FilterComponent createFilterComponent(TrackFilterPane filterPane, String itemListLabel, List<String> itemList, FilterElement element) {
        return new TrackFilterComponent(filterPane, itemListLabel, itemList, element);
    }

    public void setMatchAll(boolean value) {
        this.matchAll = value;
    }

    public boolean getMatchAll() {
        return this.matchAll;
    }

    public void applyFilterMatching() {
        Component[] filterComponents;
        for (Component filterComponent : filterComponents = this.getComponents()) {
            ((TrackFilterComponent)filterComponent).setMatchAll(this.matchAll);
        }
    }

    public void setItems(List<String> items) {
        if (items == null || items.size() < 1) {
            this.itemList = new ArrayList<String>();
            return;
        }
        this.itemList = new ArrayList<String>(items);
    }

    public boolean more() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (!this.isFilterValid()) {
            JOptionPane.showMessageDialog(window, "Some of the filter values are missing.\nPlease enter all value before pressing ok.");
            return false;
        }
        if (this.itemListLabel == null) {
            this.itemListLabel = "When";
        }
        this.add(new TrackFilterComponent(this, this.itemListLabel, this.itemList, null));
        int h = 0;
        for (Component c : this.getComponents()) {
            h += c.getHeight() + 2 * this.vgap;
        }
        this.setPreferredSize(new Dimension(this.getWidth(), h));
        return true;
    }

    public void save() {
        Component[] children;
        for (Component child : children = this.getComponents()) {
            if (!(child instanceof FilterComponent)) continue;
            ((FilterComponent)child).save();
        }
    }

    public boolean isFilterValid() {
        Component[] children;
        boolean isValid = true;
        for (Component child : children = this.getComponents()) {
            if (!(child instanceof FilterComponent)) continue;
            FilterComponent filterComponent = (FilterComponent)child;
            String item = filterComponent.getItem();
            if (item == null || item.trim().equals("")) {
                return false;
            }
            String operator = filterComponent.getComparisonOperator();
            if (operator == null || operator.trim().equals("")) {
                return false;
            }
            String string = filterComponent.getExpectedValue();
        }
        return isValid;
    }

    public void backup() {
        this.filterComponentBackup = this.getComponents();
    }

    public void adjustMoreAndBooleanButtonVisibility() {
        if (this.filterComponentBackup != null) {
            Component[] components;
            for (Component component : components = this.getComponents()) {
                ((FilterComponent)component).displayMoreButton(false);
            }
            int last = components.length - 1;
            ((FilterComponent)components[last]).displayMoreButton(true);
        }
    }

    public void restore() {
        if (this.filterComponentBackup != null) {
            Component[] components;
            this.removeAll();
            this.filter.removeAll();
            for (Component component : components = this.filterComponentBackup) {
                ((FilterComponent)component).displayMoreButton(false);
                this.add(component);
                this.filter.add(((FilterComponent)component).getFilterElement());
            }
            if (components.length > 0) {
                int last = components.length - 1;
                ((FilterComponent)components[last]).displayMoreButton(true);
            }
            this.filterComponentBackup = null;
        }
    }
}

