/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.tools.IgvTools;
import org.broad.igv.tools.Preprocessor;
import org.broad.igv.track.WindowFunction;

public class CoverageGui
extends JDialog {
    Mode mode;
    String[] zoomLevels = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    PrintStream systemOutStream;
    PrintStream systemErrStream;
    IgvTools igvTools;
    private JFileChooser fileDialog;
    private JPanel mainPanel;
    private JLabel label1;
    private JPanel requiredPanel;
    private JLabel outputLabel;
    private JButton outputButton;
    private JTextField inputField;
    private JButton inputButton;
    private JTextField outputField;
    private JLabel genomeLabel;
    private JTextField genomeField;
    private JPanel tilePanel;
    private JLabel zoomLabel;
    private JLabel windowFunctionLabel;
    private JPanel windowFunctionPanel;
    private JCheckBox minCheckBox;
    private JCheckBox maxCheckBox;
    private JCheckBox meanCheckBox;
    private JCheckBox medianCheckBox;
    private JCheckBox a2CheckBox;
    private JCheckBox a10CheckBox;
    private JCheckBox a90CheckBox;
    private JCheckBox a98CheckBox;
    private JComboBox zoomCombo;
    private JLabel windowSizeLabel;
    private JTextField windowSizeField;
    private JLabel probeLabel;
    private JTextField probeField;
    private JButton probeButton;
    private JPanel buttonPanel;
    private JButton runButton;
    private JButton closeButton;
    private JPanel OutputPanel;
    private JScrollPane outputScroll;
    private JTextArea outputText;
    private JProgressBar progressBar;

    public CoverageGui(Mode mode) {
        this.mode = mode;
        this.initComponents();
        this.initUI();
    }

    private void inputButtonActionPerformed(ActionEvent e) {
        File chosenFile = this.chooseFile();
        this.inputField.setText(chosenFile.getAbsolutePath());
        this.setDefaultOutputText();
    }

    private void inputFieldActionPerformed(ActionEvent e) {
        this.setDefaultOutputText();
    }

    private void inputFieldFocusLost(FocusEvent e) {
        this.setDefaultOutputText();
    }

    private void setDefaultOutputText() {
        if (this.inputField.getText().length() > 0) {
            this.outputField.setText(this.inputField.getText() + ".tdf");
        }
    }

    private void runButtonActionPerformed(ActionEvent e) {
        if (this.mode == Mode.COVERAGE) {
            this.doCount();
        } else {
            this.doTile();
        }
    }

    private void outputButtonActionPerformed(ActionEvent e) {
        File chosenFile = this.chooseFile();
        this.outputField.setText(chosenFile.getAbsolutePath());
    }

    private void initUI() {
        this.igvTools = new IgvTools();
        this.setContentPane(this.mainPanel);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                CoverageGui.this.close();
            }
        });
        for (String item : this.zoomLevels) {
            this.zoomCombo.addItem(item);
        }
        this.zoomCombo.setSelectedIndex(7);
        this.windowSizeField.setText(String.valueOf(25));
        this.redirectSystemStreams();
        if (this.mode == Mode.COVERAGE) {
            this.setTitle("Compute Coverage");
            this.label1.setText("");
            this.probeLabel.setVisible(false);
            this.probeField.setVisible(false);
            this.probeField.setVisible(false);
        } else {
            this.label1.setText("");
            this.setTitle("Convert to TDF");
        }
    }

    private void close() {
        System.setErr(this.systemErrStream);
        System.setOut(this.systemOutStream);
        this.dispose();
    }

    private void closeButtonActionPerformed(ActionEvent e) {
        System.setErr(this.systemErrStream);
        System.setOut(this.systemOutStream);
        this.dispose();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.label1 = new JLabel();
        this.requiredPanel = new JPanel();
        JLabel label2 = new JLabel();
        this.outputLabel = new JLabel();
        this.outputButton = new JButton();
        this.inputField = new JTextField();
        this.inputButton = new JButton();
        this.outputField = new JTextField();
        this.genomeLabel = new JLabel();
        this.genomeField = new JTextField();
        this.tilePanel = new JPanel();
        this.zoomLabel = new JLabel();
        this.windowFunctionLabel = new JLabel();
        this.windowFunctionPanel = new JPanel();
        this.minCheckBox = new JCheckBox();
        this.maxCheckBox = new JCheckBox();
        this.meanCheckBox = new JCheckBox();
        this.medianCheckBox = new JCheckBox();
        this.a2CheckBox = new JCheckBox();
        this.a10CheckBox = new JCheckBox();
        this.a90CheckBox = new JCheckBox();
        this.a98CheckBox = new JCheckBox();
        this.zoomCombo = new JComboBox();
        this.windowSizeLabel = new JLabel();
        this.windowSizeField = new JTextField();
        this.probeLabel = new JLabel();
        this.probeField = new JTextField();
        this.probeButton = new JButton();
        this.buttonPanel = new JPanel();
        this.runButton = new JButton();
        this.closeButton = new JButton();
        this.OutputPanel = new JPanel();
        this.outputScroll = new JScrollPane();
        this.outputText = new JTextArea();
        JSeparator separator1 = new JSeparator();
        this.progressBar = new JProgressBar();
        this.mainPanel.setBorder(new TitledBorder(new EtchedBorder(), ""));
        this.mainPanel.setLayout(new GridBagLayout());
        this.label1.setText("Compute coverage for an alignment or feature file.");
        this.label1.setFont(new Font("Lucida Grande", 1, 14));
        this.mainPanel.add((Component)this.label1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 10, 0), 0, 0));
        this.requiredPanel.setLayout(new GridBagLayout());
        label2.setText("Input File");
        this.requiredPanel.add((Component)label2, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.outputLabel.setText("Output File");
        this.requiredPanel.add((Component)this.outputLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.outputButton.setText("Browse");
        this.outputButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageGui.this.outputButtonActionPerformed(e);
            }
        });
        this.requiredPanel.add((Component)this.outputButton, new GridBagConstraints(3, 3, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.inputField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                CoverageGui.this.inputFieldFocusLost(e);
            }
        });
        this.inputField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageGui.this.inputFieldActionPerformed(e);
            }
        });
        this.requiredPanel.add((Component)this.inputField, new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.inputButton.setText("Browse");
        this.inputButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageGui.this.inputButtonActionPerformed(e);
                CoverageGui.this.inputButtonActionPerformed(e);
            }
        });
        this.requiredPanel.add((Component)this.inputButton, new GridBagConstraints(3, 2, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.requiredPanel.add((Component)this.outputField, new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.genomeLabel.setToolTipText("Either a genome ID (e.g. hg18) or the full path to a .genome file.");
        this.genomeLabel.setText("Genome");
        this.requiredPanel.add((Component)this.genomeLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.requiredPanel.add((Component)this.genomeField, new GridBagConstraints(2, 4, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.requiredPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.tilePanel.setEnabled(true);
        this.tilePanel.setFont(this.tilePanel.getFont().deriveFont(2, 10.0f));
        this.tilePanel.setBorder(new TitledBorder(null, "Advanced Options", 4, 2));
        this.tilePanel.setLayout(new GridBagLayout());
        this.zoomLabel.setToolTipText("<html>Specifies the maximum zoom level to precompute. The default value is 7.<br>To reduce file size at the expense of Iperformance this value can be reduced.");
        this.zoomLabel.setText("Zoom Levels");
        this.tilePanel.add((Component)this.zoomLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.windowFunctionLabel.setToolTipText("Window functions to use for summarizing data. ");
        this.windowFunctionLabel.setText("Window Functions");
        this.tilePanel.add((Component)this.windowFunctionLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.windowFunctionPanel.setLayout(new GridLayout(2, 0));
        this.minCheckBox.setText("Min");
        this.windowFunctionPanel.add(this.minCheckBox);
        this.maxCheckBox.setText("Max");
        this.windowFunctionPanel.add(this.maxCheckBox);
        this.meanCheckBox.setSelected(true);
        this.meanCheckBox.setText("Mean");
        this.windowFunctionPanel.add(this.meanCheckBox);
        this.medianCheckBox.setText("Median");
        this.windowFunctionPanel.add(this.medianCheckBox);
        this.a2CheckBox.setText("2%");
        this.windowFunctionPanel.add(this.a2CheckBox);
        this.a10CheckBox.setText("10%");
        this.windowFunctionPanel.add(this.a10CheckBox);
        this.a90CheckBox.setText("90%");
        this.windowFunctionPanel.add(this.a90CheckBox);
        this.a98CheckBox.setText("98%");
        this.windowFunctionPanel.add(this.a98CheckBox);
        this.tilePanel.add((Component)this.windowFunctionPanel, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.zoomCombo.setEditable(false);
        this.zoomCombo.setModel(new DefaultComboBoxModel<String>(new String[0]));
        this.tilePanel.add((Component)this.zoomCombo, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.windowSizeLabel.setToolTipText("The window size over which coverage computed when using the count command.  Defaults to 25 bp.");
        this.windowSizeLabel.setText("Window Size");
        this.tilePanel.add((Component)this.windowSizeLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.tilePanel.add((Component)this.windowSizeField, new GridBagConstraints(2, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.probeLabel.setFont(this.probeLabel.getFont());
        this.probeLabel.setToolTipText("<html>Specifies a \"bed\" file to be used to map probe identifiers to locations.  This option is useful <br>when preprocessing gct files.  The bed file should contain 4 columns: chr start end name\n<br>where name is the probe name in the gct file.");
        this.probeLabel.setText("Probe to Loci Mapping");
        this.tilePanel.add((Component)this.probeLabel, new GridBagConstraints(1, 5, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.tilePanel.add((Component)this.probeField, new GridBagConstraints(2, 5, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.probeButton.setText("Browse");
        this.tilePanel.add((Component)this.probeButton, new GridBagConstraints(3, 5, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.tilePanel, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.buttonPanel.setLayout(new GridBagLayout());
        this.runButton.setText("Run");
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageGui.this.runButtonActionPerformed(e);
            }
        });
        this.buttonPanel.add((Component)this.runButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageGui.this.closeButtonActionPerformed(e);
            }
        });
        this.buttonPanel.add((Component)this.closeButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.buttonPanel, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.OutputPanel.setBorder(new TitledBorder(BorderFactory.createEmptyBorder(), "Messages", 4, 2));
        this.OutputPanel.setLayout(null);
        this.outputText.setEditable(false);
        this.outputText.setText("");
        this.outputText.setRows(10);
        this.outputScroll.setViewportView(this.outputText);
        this.OutputPanel.add(this.outputScroll);
        this.outputScroll.setBounds(4, 20, 881, this.outputScroll.getPreferredSize().height);
        Dimension preferredSize = new Dimension();
        for (int i = 0; i < this.OutputPanel.getComponentCount(); ++i) {
            Rectangle bounds = this.OutputPanel.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = this.OutputPanel.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.OutputPanel.setMinimumSize(preferredSize);
        this.OutputPanel.setPreferredSize(preferredSize);
        this.mainPanel.add((Component)this.OutputPanel, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.mainPanel.add((Component)separator1, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.mainPanel.add((Component)this.progressBar, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void updateTextArea(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CoverageGui.this.outputText.append(text);
            }
        });
    }

    protected void redirectSystemStreams() {
        OutputStream out = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                CoverageGui.this.updateTextArea(String.valueOf((char)b));
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                CoverageGui.this.updateTextArea(new String(b, off, len));
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }
        };
        this.systemOutStream = System.out;
        this.systemErrStream = System.err;
        System.setOut(new PrintStream(out, true));
        System.setErr(new PrintStream(out, true));
    }

    protected void showMessage(String tool) {
        JOptionPane.showMessageDialog(this, tool);
    }

    protected void doCount() {
        SwingWorker swingWorker = new SwingWorker(){

            protected Object doInBackground() {
                try {
                    CoverageGui.this.setCursor(Cursor.getPredefinedCursor(3));
                    String ifile = CoverageGui.this.inputField.getText();
                    String ofile = CoverageGui.this.outputField.getText();
                    String genomeId = CoverageGui.this.genomeField.getText();
                    int maxZoomValue = Integer.parseInt(CoverageGui.this.zoomCombo.getSelectedItem().toString());
                    Collection wfs = CoverageGui.this.getWindowFunctions();
                    String windowSizeText = CoverageGui.this.windowSizeField.getText();
                    int windowSize = windowSizeText != null && windowSizeText.length() > 0 ? Integer.parseInt(windowSizeText) : 25;
                    int extFactor = 0;
                    int strandOption = -1;
                    CoverageGui.this.runButton.setEnabled(false);
                    int countFlags = 0;
                    boolean includeDuplicates = PreferencesManager.getPreferences().getAsBoolean("SAM.SHOW_DUPLICATES") || !PreferencesManager.getPreferences().getAsBoolean("SAM.FILTER_DUPLICATES");
                    int minMappingQuality = PreferencesManager.getPreferences().getAsInt("SAM.QUALITY_THRESHOLD");
                    if (includeDuplicates) {
                        countFlags += 32;
                    }
                    int preExtFactor = 0;
                    int postExtFactor = 0;
                    CoverageGui.this.igvTools.doCount(ifile, ofile, genomeId, maxZoomValue, wfs, windowSize, extFactor, preExtFactor, postExtFactor, null, null, minMappingQuality, countFlags);
                }
                catch (Exception e) {
                    CoverageGui.this.showMessage("Error: " + e.getMessage());
                }
                return null;
            }

            @Override
            protected void done() {
                CoverageGui.this.runButton.setEnabled(true);
                CoverageGui.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        swingWorker.execute();
    }

    private void doTile() {
        SwingWorker swingWorker = new SwingWorker(){

            protected Object doInBackground() {
                try {
                    CoverageGui.this.setCursor(Cursor.getPredefinedCursor(3));
                    String ifile = CoverageGui.this.inputField.getText();
                    String ofile = CoverageGui.this.outputField.getText();
                    String genomeId = CoverageGui.this.genomeField.getText();
                    int maxZoomValue = Integer.parseInt(CoverageGui.this.zoomCombo.getSelectedItem().toString());
                    Collection wfs = CoverageGui.this.getWindowFunctions();
                    String probeFile = CoverageGui.this.probeField.getText();
                    String typeString = Preprocessor.getExtension("ifile");
                    CoverageGui.this.runButton.setEnabled(false);
                    CoverageGui.this.igvTools.toTDF(typeString, ifile, ofile, probeFile, genomeId, maxZoomValue, wfs, null, 500000);
                }
                catch (Exception e) {
                    CoverageGui.this.showMessage("Error: " + e.getMessage());
                }
                return null;
            }

            @Override
            protected void done() {
                CoverageGui.this.runButton.setEnabled(true);
                CoverageGui.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        swingWorker.execute();
    }

    private Collection<WindowFunction> getWindowFunctions() {
        ArrayList<WindowFunction> wfs = new ArrayList<WindowFunction>();
        if (this.minCheckBox.isSelected()) {
            wfs.add(WindowFunction.min);
        }
        if (this.maxCheckBox.isSelected()) {
            wfs.add(WindowFunction.max);
        }
        if (this.meanCheckBox.isSelected()) {
            wfs.add(WindowFunction.mean);
        }
        if (this.a98CheckBox.isSelected()) {
            wfs.add(WindowFunction.percentile98);
        }
        if (this.a90CheckBox.isSelected()) {
            wfs.add(WindowFunction.percentile90);
        }
        if (this.a10CheckBox.isSelected()) {
            wfs.add(WindowFunction.percentile10);
        }
        if (this.a2CheckBox.isSelected()) {
            wfs.add(WindowFunction.percentile2);
        }
        if (wfs.isEmpty()) {
            wfs.add(WindowFunction.mean);
        }
        return wfs;
    }

    protected File chooseFile() {
        if (this.fileDialog == null) {
            this.fileDialog = new JFileChooser();
        }
        this.fileDialog.setMultiSelectionEnabled(false);
        this.fileDialog.setFileSelectionMode(0);
        int returnVal = this.fileDialog.showDialog(this, "Select File");
        if (returnVal == 1) {
            return null;
        }
        File selected = this.fileDialog.getSelectedFile();
        return selected;
    }

    public static void launch(boolean modal, String genomeId, Mode mode) {
        CoverageGui mainWindow = new CoverageGui(mode);
        mainWindow.pack();
        mainWindow.setModal(modal);
        mainWindow.setDefaultCloseOperation(2);
        mainWindow.setResizable(false);
        if (genomeId != null) {
            mainWindow.genomeField.setText(genomeId);
            mainWindow.genomeField.setEnabled(false);
            mainWindow.genomeField.setToolTipText("<html>To change the genome id close this window and <br>use the pulldown on the IGV batch screen.");
        }
        mainWindow.setVisible(true);
    }

    public static enum Mode {
        COVERAGE,
        TILE;

    }
}

