/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.sort;

import htsjdk.tribble.readers.AsciiLineReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.log4j.Logger;
import org.broad.igv.tools.sort.AsciiSorter;
import org.broad.igv.tools.sort.Parser;

public class CNSorter
extends AsciiSorter {
    private static Logger log = Logger.getLogger(AsciiSorter.class);

    public CNSorter(File inputFile, File outputFile) {
        super(inputFile, outputFile);
    }

    @Override
    String writeHeader(AsciiLineReader reader, PrintWriter writer) throws IOException {
        String nextLine = reader.readLine();
        while (nextLine.startsWith("#") || nextLine.trim().length() == 0) {
            writer.println(nextLine);
            nextLine = reader.readLine();
        }
        writer.println(nextLine);
        if (!nextLine.startsWith("SNP")) {
            log.warn("Expected header line not found");
        }
        return null;
    }

    @Override
    Parser getParser() throws IOException {
        String fn;
        String tmp = this.inputFile.getName();
        String string = fn = tmp.endsWith(".txt") ? tmp.substring(0, tmp.length() - 4) : tmp;
        if (fn.endsWith(".cn") || fn.endsWith(".xcn") || fn.endsWith(".snp")) {
            return new Parser(1, 2);
        }
        if (fn.endsWith(".igv")) {
            return this.getIGVParser();
        }
        throw new RuntimeException("Unrecognized copy number extension: " + fn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Parser getIGVParser() throws IOException {
        int chrColumn = 0;
        int startColumn = 1;
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new FileReader(this.inputFile));
            String nextLine = "";
            while ((nextLine = reader.readLine()) != null && nextLine.startsWith("#")) {
                if (!nextLine.startsWith("#columns")) continue;
                String[] tokens2 = nextLine.split("\\s+");
                if (tokens2.length <= 1) break;
                for (int i = 1; i < tokens2.length; ++i) {
                    int c;
                    String[] kv = tokens2[i].split("=");
                    if (kv.length != 2) continue;
                    if (kv[0].toLowerCase().equals("chr")) {
                        c = Integer.parseInt(kv[1]);
                        if (c < 1) {
                            throw new RuntimeException("Error parsing column line: " + nextLine + ". Column numbers must be > 0");
                        }
                        chrColumn = c - 1;
                        continue;
                    }
                    if (!kv[0].toLowerCase().equals("start")) continue;
                    c = Integer.parseInt(kv[1]);
                    if (c < 1) {
                        throw new RuntimeException("Error parsing column line: " + nextLine + ". Column numbers must be > 0");
                    }
                    startColumn = c - 1;
                }
            }
            Parser parser = new Parser(chrColumn, startColumn);
            return parser;
        }
    }
}

