/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.util.ArrayList;
import java.util.Collection;
import org.broad.igv.feature.Range;
import org.broad.igv.util.collections.LRUCache;

class PositionCache<V> {
    private LRUCache<Range, V> intervals = new LRUCache(10);
    private static final int MIN_MAX_ENTRIES = 10;

    public PositionCache() {
    }

    public PositionCache(PositionCache<V> cache2) {
        this.intervals.putAll(cache2.intervals);
    }

    public V put(Range range, V value) {
        Range currentRangeKey = this.getKeyForRange(range);
        Range keyToUse = currentRangeKey != null ? currentRangeKey : range;
        return this.intervals.put(keyToUse, value);
    }

    public V getForRange(Range range) {
        Range key = this.getKeyForRange(range);
        return key != null ? (V)this.intervals.get(key) : null;
    }

    private Range getKeyForRange(Range range) {
        String chr = range.getChr();
        for (Range cachedRange : this.intervals.keySet()) {
            if (!cachedRange.contains(chr, range.getStart(), range.getEnd())) continue;
            return cachedRange;
        }
        return null;
    }

    public boolean containsRange(Range range) {
        return this.getKeyForRange(range) != null;
    }

    public Collection<V> values() {
        return new ArrayList<V>(this.intervals.values());
    }

    public void clear() {
        this.intervals.clear();
    }

    public synchronized void setMaxEntries(int inMaxEntries) {
        int newMax = Math.max(10, inMaxEntries);
        this.intervals.setMaxEntries(newMax);
    }
}

