/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ga4gh;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.prefs.Preferences;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.batch.CommandListener;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;

public class OAuthUtils {
    private static Logger log = Logger.getLogger(OAuthUtils.class);
    public String authProvider = "Google";
    private String appIdURI = null;
    public static String findString = null;
    public static String replaceString = null;
    private static final String REFRESH_TOKEN_KEY = "oauth_refresh_token";
    private static final String PROPERTIES_URL = "https://s3.amazonaws.com/igv.org.app/desktop_google";
    private String genomicsScope = "https://www.googleapis.com/auth/genomics";
    private String gsScope = "https://www.googleapis.com/auth/devstorage.read_write";
    private String emailScope = "https://www.googleapis.com/auth/userinfo.email";
    private String state = "%2Fprofile";
    private String redirectURI = "http%3A%2F%2Flocalhost%3A60151%2FoauthCallback";
    private String oobURI = "urn%3Aietf%3Awg%3Aoauth%3A2.0%3Aoob";
    private String clientId;
    private String clientSecret;
    private String authURI;
    private String tokenURI;
    private String authorizationCode;
    private String accessToken;
    private String refreshToken;
    private long expirationTime;
    public static String GS_HOST = "www.googleapis.com";
    private static OAuthUtils theInstance;
    private String currentUserName;
    private String scope = this.genomicsScope + "%20" + this.gsScope + "%20" + this.emailScope;

    public static synchronized OAuthUtils getInstance() throws IOException {
        if (theInstance == null) {
            theInstance = new OAuthUtils();
        }
        return theInstance;
    }

    private OAuthUtils() throws IOException {
        this.restoreRefreshToken();
        this.fetchOauthProperties();
    }

    public void fetchOauthProperties() throws IOException {
        String oauthConfig = DirectoryManager.getIgvDirectory() + "/oauth-config.json";
        if (oauthConfig == null || !FileUtils.resourceExists(oauthConfig)) {
            String propString = HttpUtils.getInstance().getContentsAsGzippedString(HttpUtils.createURL(PROPERTIES_URL));
            JsonParser parser = new JsonParser();
            JsonObject obj = parser.parse(propString).getAsJsonObject().get("installed").getAsJsonObject();
            this.authURI = obj.get("auth_uri").getAsString();
            this.clientSecret = obj.get("client_secret").getAsString();
            this.tokenURI = obj.get("token_uri").getAsString();
            this.clientId = obj.get("client_id").getAsString();
        } else {
            JsonElement je;
            JsonParser parser = new JsonParser();
            String json = FileUtils.getContents(oauthConfig);
            JsonObject obj = parser.parse(json).getAsJsonObject();
            this.authURI = obj.get("authorization_endpoint").getAsString();
            this.clientSecret = obj.get("client_secret").getAsString();
            this.tokenURI = obj.get("token_endpoint").getAsString();
            this.clientId = obj.get("client_id").getAsString();
            GS_HOST = obj.get("hosts").getAsString();
            this.appIdURI = obj.get("app_id_uri").getAsString();
            this.authProvider = obj.get("auth_provider").getAsString();
            String scope = obj.get("scope").getAsString();
            if (scope.equals("none")) {
                this.scope = null;
            }
            if ((je = obj.get("find_string")) != null) {
                findString = je.getAsString();
            }
            if ((je = obj.get("replace_string")) != null) {
                replaceString = je.getAsString();
            }
        }
    }

    public void openAuthorizationPage() throws IOException, URISyntaxException {
        String ac;
        Desktop desktop = Desktop.getDesktop();
        String redirect = this.oobURI;
        if (CommandListener.isListening()) {
            redirect = this.redirectURI;
        }
        String url = this.appIdURI == null ? this.authURI + "?scope=" + this.scope + "&state=" + this.state + "&redirect_uri=" + redirect + "&response_type=code&client_id=" + this.clientId : this.authURI + "?scope=" + this.scope + "&state=" + this.state + "&redirect_uri=" + redirect + "&response_type=code&resource=" + this.appIdURI + "&client_id=" + this.clientId;
        if (desktop.isSupported(Desktop.Action.BROWSE)) {
            desktop.browse(new URI(url));
        } else {
            MessageUtils.showMessage("Copy this authorization URL into your web browser: " + url);
        }
        if (!CommandListener.isListening() && (ac = MessageUtils.showInputDialog("Please paste authorization code here:")) != null) {
            this.setAuthorizationCode(ac, this.oobURI);
        }
    }

    public void setAuthorizationCode(String ac) throws IOException {
        this.setAuthorizationCode(ac, this.redirectURI);
    }

    public void setAuthorizationCode(String ac, String redirect) throws IOException {
        this.authorizationCode = ac;
        this.fetchTokens(redirect);
        this.fetchUserProfile();
    }

    public void setAccessToken(String accessToken) throws IOException {
        this.accessToken = accessToken;
        this.fetchUserProfile();
    }

    private void fetchTokens(String redirect) throws IOException {
        URL url = HttpUtils.createURL(this.tokenURI);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", this.authorizationCode);
        params.put("client_id", this.clientId);
        params.put("client_secret", this.clientSecret);
        params.put("redirect_uri", redirect);
        params.put("grant_type", "authorization_code");
        if (this.appIdURI != null) {
            params.put("resource", this.appIdURI);
        }
        String response = HttpUtils.getInstance().doPost(url, params);
        JsonParser parser = new JsonParser();
        JsonObject obj = parser.parse(response).getAsJsonObject();
        this.accessToken = obj.getAsJsonPrimitive("access_token").getAsString();
        this.refreshToken = obj.getAsJsonPrimitive("refresh_token").getAsString();
        this.expirationTime = System.currentTimeMillis() + (long)(obj.getAsJsonPrimitive("expires_in").getAsInt() * 1000);
        this.saveRefreshToken();
    }

    private void refreshAccessToken() throws IOException {
        String response;
        JsonParser parser;
        JsonObject obj;
        JsonPrimitive atprim;
        URL url = HttpUtils.createURL(this.tokenURI);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("refresh_token", this.refreshToken);
        params.put("client_id", this.clientId);
        params.put("client_secret", this.clientSecret);
        params.put("grant_type", "refresh_token");
        if (this.appIdURI != null) {
            params.put("resource", this.appIdURI);
        }
        if ((atprim = (obj = (parser = new JsonParser()).parse(response = HttpUtils.getInstance().doPost(url, params)).getAsJsonObject()).getAsJsonPrimitive("access_token")) != null) {
            this.accessToken = obj.getAsJsonPrimitive("access_token").getAsString();
            this.expirationTime = System.currentTimeMillis() + (long)(obj.getAsJsonPrimitive("expires_in").getAsInt() * 1000);
            this.fetchUserProfile();
        } else {
            this.reauthorize();
        }
    }

    private void reauthorize() throws IOException {
        this.logout();
        try {
            this.openAuthorizationPage();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public JsonObject fetchUserProfile() throws IOException {
        try {
            URL url = new URL("https://www.googleapis.com/oauth2/v1/userinfo?access_token=" + this.accessToken);
            String response = HttpUtils.getInstance().getContentsAsJSON(url);
            JsonParser parser = new JsonParser();
            JsonObject obj = parser.parse(response).getAsJsonObject();
            this.currentUserName = obj.get("name").getAsString();
            return obj;
        }
        catch (Throwable exception) {
            log.error(exception);
            return null;
        }
    }

    public String getAccessToken() {
        if ((this.accessToken == null || System.currentTimeMillis() > this.expirationTime - 60000L) && this.refreshToken != null) {
            try {
                this.refreshAccessToken();
            }
            catch (IOException e) {
                log.error("Error fetching access token", e);
            }
        }
        return this.accessToken;
    }

    public boolean isLoggedIn() {
        return this.getAccessToken() != null;
    }

    public String getCurrentUserName() {
        return this.currentUserName;
    }

    public void logout() {
        this.accessToken = null;
        this.refreshToken = null;
        this.expirationTime = -1L;
        this.currentUserName = null;
        this.removeRefreshToken();
    }

    private void saveRefreshToken() {
        try {
            Preferences.userRoot().put(REFRESH_TOKEN_KEY, this.refreshToken);
        }
        catch (Exception e) {
            log.error("Error storing refresh token", e);
        }
    }

    private void restoreRefreshToken() {
        try {
            this.refreshToken = Preferences.userRoot().get(REFRESH_TOKEN_KEY, null);
        }
        catch (Exception e) {
            log.error("Error fetching oauth refresh token", e);
        }
    }

    private void removeRefreshToken() {
        try {
            Preferences.userRoot().remove(REFRESH_TOKEN_KEY);
        }
        catch (Exception e) {
            log.error("Error removing oauth refresh token", e);
        }
    }

    public static boolean isGoogleCloud(String url) {
        return url.startsWith("gs://") || url.contains(GS_HOST);
    }

    public void updateSaveOption(boolean aBoolean) {
        if (aBoolean) {
            if (this.refreshToken != null) {
                this.saveRefreshToken();
            }
        } else {
            this.removeRefreshToken();
        }
    }

    public void doSecureLogin() {
        if (!this.isLoggedIn()) {
            try {
                OAuthUtils.getInstance().openAuthorizationPage();
            }
            catch (Exception ex) {
                MessageUtils.showErrorMessage("Error fetching oAuth tokens.  See log for details", ex);
                log.error("Error fetching oAuth tokens", ex);
            }
        }
        int i = 0;
        while (!this.isLoggedIn() && i < 600) {
            ++i;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> findUrlsInSessionFile(String sessionPath) {
        BufferedReader br = null;
        HashSet<String> urlSet = new HashSet<String>();
        try {
            String line;
            br = new BufferedReader(new FileReader(new File(sessionPath)));
            while ((line = br.readLine()) != null) {
                int start = line.indexOf("http");
                if (start == -1) continue;
                int mid = line.indexOf("://", start);
                int end = line.indexOf("/", mid + 3);
                String url = line.substring(start, end);
                urlSet.add(url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return urlSet;
    }

    public void checkServerLogin(String sessionPath) {
        Set<String> urlSet = OAuthUtils.findUrlsInSessionFile(sessionPath);
        if (urlSet.size() > 0) {
            for (String url : urlSet) {
                if (!OAuthUtils.isGoogleCloud(url)) continue;
                this.doSecureLogin();
                return;
            }
        }
    }
}

