/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.Feature;
import htsjdk.tribble.exception.CodecLineParsingException;
import htsjdk.tribble.readers.LineIterator;
import org.broad.igv.Globals;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.FeatureFileHeader;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.collections.MultiMap;

public class REPMaskCodec
extends AsciiFeatureCodec<BasicFeature> {
    FeatureFileHeader header;
    Genome genome;

    public REPMaskCodec(Genome genome) {
        super(BasicFeature.class);
        this.genome = genome;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object readActualHeader(LineIterator reader) {
        this.header = new FeatureFileHeader();
        this.header.setTrackType(TrackType.REPMASK);
        int nLines = 0;
        try {
            while (reader.hasNext()) {
                String nextLine = reader.peek();
                if (!(nextLine.startsWith("#") || nextLine.startsWith("track") || nextLine.startsWith("browser"))) {
                    return this.header;
                }
                reader.next();
                ++nLines;
                if (nextLine.startsWith("#type")) {
                    String[] tokens2 = nextLine.split("=");
                    if (tokens2.length <= 1) continue;
                    try {
                        this.header.setTrackType(TrackType.valueOf(tokens2[1]));
                        continue;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                if (!nextLine.startsWith("track")) continue;
                TrackProperties tp = new TrackProperties();
                ParsingUtils.parseTrackLine(nextLine, tp);
                this.header.setTrackProperties(tp);
            }
            return this.header;
        }
        catch (Exception e) {
            throw new CodecLineParsingException("Error parsing header: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean canDecode(String path) {
        return true;
    }

    @Override
    public Feature decodeLoc(String line) {
        String[] tokens2 = Globals.singleTabMultiSpacePattern.split(line);
        if (tokens2.length < 15) {
            return this.decodeLegacy(tokens2);
        }
        String chr = this.genome == null ? tokens2[5] : this.genome.getCanonicalChrName(tokens2[5]);
        int start = Integer.parseInt(tokens2[6]);
        int end = Integer.parseInt(tokens2[7]);
        return new BasicFeature(chr, start, end);
    }

    @Override
    public BasicFeature decode(String nextLine) {
        int strand;
        if (nextLine.trim().length() == 0 || nextLine.startsWith("#")) {
            return null;
        }
        String[] tokens2 = Globals.singleTabMultiSpacePattern.split(nextLine);
        int tokenCount = tokens2.length;
        if (tokenCount < 15) {
            return this.decodeLegacy(tokens2);
        }
        String chr = this.genome == null ? tokens2[5] : this.genome.getCanonicalChrName(tokens2[5]);
        int start = Integer.parseInt(tokens2[6]);
        int end = Integer.parseInt(tokens2[7]);
        BasicFeature feature = new BasicFeature(chr, start, end);
        feature.setRepresentation(nextLine);
        String strandString = tokens2[3].trim();
        int n = strand = strandString.length() == 0 ? 32 : (int)strandString.charAt(0);
        if (strand == 45) {
            feature.setStrand(Strand.NEGATIVE);
        } else if (strand == 43) {
            feature.setStrand(Strand.POSITIVE);
        } else {
            feature.setStrand(Strand.NONE);
        }
        String name = tokens2[10];
        feature.setName(name);
        feature.setIdentifier(name);
        MultiMap<String, String> attributes = new MultiMap<String, String>();
        attributes.put("Smith Waterman score", tokens2[1]);
        attributes.put("base mismatches per thousand", tokens2[2]);
        attributes.put("bases deleted per thousand", tokens2[3]);
        attributes.put("bases inserted per thousand", tokens2[4]);
        attributes.put("repeat class", tokens2[11]);
        attributes.put("repeat family", tokens2[12]);
        attributes.put("repeat start", tokens2[13]);
        attributes.put("repeat end", tokens2[14]);
        feature.setAttributes(attributes);
        return feature;
    }

    public BasicFeature decodeLegacy(String[] tokens2) {
        int tokenCount = tokens2.length;
        if (tokenCount < 2) {
            return null;
        }
        String chr = this.genome == null ? tokens2[0] : this.genome.getCanonicalChrName(tokens2[0]);
        int start = Integer.parseInt(tokens2[1]);
        int end = start + 1;
        if (tokenCount > 2) {
            end = Integer.parseInt(tokens2[2]);
        }
        BasicFeature feature = new BasicFeature(chr, start, end);
        if (tokenCount > 3) {
            int strand;
            String strandString = tokens2[3].trim();
            int n = strand = strandString.length() == 0 ? 32 : (int)strandString.charAt(0);
            if (strand == 45) {
                feature.setStrand(Strand.NEGATIVE);
            } else if (strand == 43) {
                feature.setStrand(Strand.POSITIVE);
            } else {
                feature.setStrand(Strand.NONE);
            }
        }
        if (tokenCount > 4) {
            String name = tokens2[4].replaceAll("\"", "");
            feature.setName(name);
            feature.setIdentifier(name);
        }
        return feature;
    }
}

