/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.readers.AsciiLineReader;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.tribble.readers.LineIteratorImpl;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.MUTCodec;
import org.broad.igv.feature.tribble.PAFFeature;
import org.broad.igv.util.ParsingUtils;

public class PAFCodec
extends AsciiFeatureCodec<PAFFeature> {
    private static Logger log = Logger.getLogger(MUTCodec.class);
    private static int chrColumn = 5;
    private static int startColumn = 7;
    private static int endColumn = 8;
    private static int scoreColumn = 11;
    private String path;
    private Genome genome;
    private int errorCount = 0;

    public PAFCodec(String path, Genome genome) {
        super(PAFFeature.class);
        this.path = path;
        this.genome = genome;
        try {
            LineIteratorImpl reader = new LineIteratorImpl(new AsciiLineReader(ParsingUtils.openInputStream(path)));
            this.readActualHeader(reader);
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
        }
    }

    @Override
    public Object readActualHeader(LineIterator reader) {
        return null;
    }

    @Override
    public PAFFeature decode(String line) {
        float score;
        int end;
        int start;
        String[] tokens2 = Globals.tabPattern.split(line);
        StringBuffer description = new StringBuffer();
        String chr = this.genome == null ? tokens2[chrColumn].trim() : this.genome.getCanonicalChrName(tokens2[chrColumn].trim());
        try {
            start = Integer.parseInt(tokens2[startColumn].trim());
        }
        catch (NumberFormatException e) {
            throw new DataLoadException("Column " + (startColumn + 1) + " must be a numeric value.", this.path);
        }
        try {
            end = Integer.parseInt(tokens2[endColumn].trim());
        }
        catch (NumberFormatException e) {
            throw new DataLoadException("Column " + (endColumn + 1) + " must be a numeric value.", this.path);
        }
        Strand strand = tokens2[4].equals("+") ? Strand.POSITIVE : (tokens2[4].equals("-") ? Strand.NEGATIVE : Strand.NONE);
        try {
            score = (float)Double.parseDouble(tokens2[scoreColumn]);
        }
        catch (NumberFormatException e) {
            throw new DataLoadException("Column " + (scoreColumn + 1) + " must be a numeric value.", this.path);
        }
        String name = tokens2[0] + ":" + tokens2[2] + "-" + tokens2[3];
        description.append("Query sequence name: " + tokens2[0] + "<br>");
        description.append("Query sequence length: " + tokens2[1] + "<br>");
        description.append("Query start (0-based): " + tokens2[2] + "<br>");
        description.append("Query end (0-based):" + tokens2[3] + "<br>");
        description.append("Relative strand: " + tokens2[4] + "<br>");
        description.append("Target sequence name: " + tokens2[5] + "<br>");
        description.append("Target sequence length: " + tokens2[6] + "<br>");
        description.append("Target start (0-based): " + tokens2[7] + "<br>");
        description.append("Target end (0-based): " + tokens2[8] + "<br>");
        description.append("Number of residual matches: " + tokens2[9] + "<br>");
        description.append("Alignment block length: " + tokens2[10] + "<br>");
        description.append("Mapping quality (0-255): " + tokens2[11] + "<br>");
        for (int i = 12; i < tokens2.length; ++i) {
            String tag = tokens2[i];
            if (tag.startsWith("cg")) continue;
            description.append(tag + "<br>");
        }
        return new PAFFeature(chr, start, end, strand, score, name, description.toString());
    }

    @Override
    public boolean canDecode(String path) {
        String fn = path.toLowerCase();
        if (fn.endsWith(".gz")) {
            fn = fn.substring(0, fn.length() - 3);
        }
        return fn.endsWith(".paf");
    }
}

