/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import org.broad.igv.Globals;
import org.broad.igv.feature.EncodePeakFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.UCSCCodec;

public class EncodePeakCodec
extends UCSCCodec {
    Genome genome;

    public EncodePeakCodec() {
        this((Genome)null);
    }

    public EncodePeakCodec(Genome genome) {
        super(EncodePeakFeature.class);
        this.genome = genome;
    }

    @Override
    public EncodePeakFeature decode(String nextLine) {
        int strandChar;
        if (nextLine.trim().length() == 0) {
            return null;
        }
        if (nextLine.startsWith("#") || nextLine.startsWith("track") || nextLine.startsWith("browser")) {
            return null;
        }
        String[] tokens2 = Globals.tabPattern.split(nextLine);
        int tokenCount = tokens2.length;
        if (tokenCount < 9) {
            return null;
        }
        String c = tokens2[0];
        String chr = this.genome == null ? c : this.genome.getCanonicalChrName(c);
        int start = Integer.parseInt(tokens2[1]);
        int end = Integer.parseInt(tokens2[2]);
        EncodePeakFeature feature = new EncodePeakFeature(chr, start, end);
        feature.setName(tokens2[3]);
        feature.setScore(Float.parseFloat(tokens2[4]));
        String strandString = tokens2[5].trim();
        int n = strandChar = strandString.length() == 0 ? 32 : (int)strandString.charAt(0);
        Strand strand = strandChar == 45 ? Strand.NEGATIVE : (strandChar == 43 ? Strand.POSITIVE : Strand.NONE);
        feature.setStrand(strand);
        feature.setSignal((float)Double.parseDouble(tokens2[6]));
        feature.setPValue((float)Double.parseDouble(tokens2[7]));
        feature.setQValue((float)Double.parseDouble(tokens2[8]));
        return feature;
    }

    @Override
    public boolean canDecode(String s) {
        return s.toLowerCase().endsWith("peak");
    }
}

