/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import htsjdk.tribble.Feature;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.Strand;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.StringUtils;

public class GenbankParser {
    private static Logger log = Logger.getLogger(GenbankParser.class);
    private String path;
    private String accession;
    private byte[] sequence;
    private List<Feature> features;
    private String locusName;
    private String[] aliases;
    private static List<String> nameFields = Arrays.asList("gene");

    public GenbankParser(String path) throws IOException {
        this.path = path;
        this.readFeatures(true);
    }

    public GenbankParser() throws IOException {
    }

    public void readFeatures(boolean readSequence) throws IOException {
        try (BufferedReader reader = null;){
            reader = ParsingUtils.openBufferedReader(this.path);
            this.readFeatures_(readSequence, reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFeatures(InputStream inputStream, boolean readSequence) throws IOException {
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new InputStreamReader(inputStream));
            this.readFeatures_(readSequence, reader);
        }
    }

    private void readFeatures_(boolean readSequence, BufferedReader reader) throws IOException {
        this.readLocus(reader);
        String line = null;
        do {
            if ((line = reader.readLine()).startsWith("ACCESSION")) {
                this.readAccession(line);
                continue;
            }
            if (!line.startsWith("ALIASES")) continue;
            this.readAliases(line);
        } while (line != null && !line.startsWith("FEATURES"));
        this.readFeatures(reader);
        if (readSequence) {
            this.readOriginSequence(reader);
        }
    }

    public byte[] getSequence(String chr, int qstart, int qend) {
        if (this.sequence == null) {
            return null;
        }
        int start = Math.max(0, qstart);
        int end = Math.min(this.sequence.length, qend);
        int len = end - start;
        byte[] bytes2 = new byte[len];
        Arrays.fill(bytes2, (byte)0);
        int s = Math.max(start, 0);
        System.arraycopy(this.sequence, s, bytes2, 0, len);
        return bytes2;
    }

    public int getSequenceLenth() {
        return this.sequence == null ? 0 : this.sequence.length;
    }

    private void readLocus(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        String[] tokens2 = Globals.whitespacePattern.split(line);
        if (!tokens2[0].equalsIgnoreCase("LOCUS")) {
            // empty if block
        }
        this.locusName = tokens2[1].trim();
    }

    private void readAccession(String line) {
        String[] tokens2 = Globals.whitespacePattern.split(line);
        if (tokens2.length < 2) {
            log.info("Genbank file missing ACCESSION number.");
        } else {
            this.accession = tokens2[1].trim();
        }
    }

    private void readAliases(String line) {
        String[] tokens2 = Globals.whitespacePattern.split(line);
        if (tokens2.length >= 2) {
            this.aliases = Globals.commaPattern.split(tokens2[1]);
        }
    }

    private void readOriginSequence(BufferedReader reader) throws IOException {
        String nextLine;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(100000);
        while ((nextLine = reader.readLine()) != null && !nextLine.startsWith("//")) {
            nextLine = nextLine.trim();
            String[] tokens2 = Globals.whitespacePattern.split(nextLine);
            for (int i = 1; i < tokens2.length; ++i) {
                buffer.write(tokens2[i].getBytes());
            }
        }
        this.sequence = buffer.toByteArray();
    }

    public String getChr() {
        return this.accession == null ? this.locusName : this.accession;
    }

    private void readFeatures(BufferedReader reader) throws IOException {
        String chr = this.getChr();
        this.features = new ArrayList<Feature>();
        BasicFeature f = null;
        String currentLocQualifier = null;
        String nextLine = null;
        int errorCount = 0;
        while ((nextLine = reader.readLine()) != null && !nextLine.startsWith("ORIGIN")) {
            if (nextLine.length() < 6) {
                if (errorCount < 10) {
                    log.error("Unexpected line in genbank file (skipping): " + nextLine);
                }
                ++errorCount;
                continue;
            }
            if (nextLine.charAt(5) != ' ') {
                String featureType = nextLine.substring(5, 21).trim();
                f = new BasicFeature();
                f.setChr(chr);
                f.setType(featureType);
                currentLocQualifier = nextLine.substring(21);
                if (featureType.toLowerCase().equals("source")) continue;
                this.features.add(f);
                continue;
            }
            String tmp = nextLine.substring(21).trim();
            if (tmp.length() <= 0) continue;
            if (tmp.charAt(0) == '/') {
                if (currentLocQualifier.charAt(0) == '/') {
                    String[] tokens2 = Globals.equalPattern.split(currentLocQualifier, 2);
                    if (tokens2.length > 1) {
                        String keyName = tokens2[0].length() > 1 ? tokens2[0].substring(1) : "";
                        String value = StringUtils.stripQuotes(tokens2[1]);
                        f.setAttribute(keyName, value);
                        if (nameFields.contains(keyName)) {
                            f.setName(value);
                        }
                    }
                } else {
                    Strand strand = currentLocQualifier.contains("complement") ? Strand.NEGATIVE : Strand.POSITIVE;
                    f.setStrand(strand);
                    String joinString = currentLocQualifier.replace("join", "");
                    joinString = joinString.replace("order", "");
                    joinString = joinString.replace("complement", "");
                    joinString = joinString.replace("(", "");
                    joinString = joinString.replace(")", "");
                    if (joinString.contains("..")) {
                        joinString = joinString.replace("<", "");
                        joinString = joinString.replace(">", "");
                        List<Exon> exons = this.createExons(joinString, strand);
                        FeatureUtils.sortFeatureList(exons);
                        Exon firstExon = exons.get(0);
                        f.setStart(firstExon.getStart());
                        Exon lastExon = exons.get(exons.size() - 1);
                        f.setEnd(lastExon.getEnd());
                        if (exons.size() > 1) {
                            for (Exon exon : exons) {
                                f.addExon(exon);
                            }
                        }
                    } else {
                        int start = Integer.parseInt(joinString) - 1;
                        int end = start + 1;
                        f.setStart(start);
                        f.setEnd(end);
                    }
                }
                currentLocQualifier = tmp;
                continue;
            }
            currentLocQualifier = currentLocQualifier == null ? tmp : currentLocQualifier + tmp;
        }
    }

    List<Exon> createExons(String joinString, Strand strand) {
        String[] lociArray = joinString.split(",");
        ArrayList<Exon> exons = new ArrayList<Exon>(lociArray.length);
        boolean isNegative = joinString.contains("complement");
        for (String loci : lociArray) {
            String[] tmp = loci.split("\\.\\.");
            int exonStart = 0;
            try {
                exonStart = Integer.parseInt(tmp[0]) - 1;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            int exonEnd = exonStart + 1;
            if (tmp.length > 1) {
                exonEnd = Integer.parseInt(tmp[1]);
            }
            Exon r = new Exon(this.accession, exonStart, exonEnd, strand);
            exons.add(r);
        }
        return exons;
    }

    public String getAccession() {
        return this.accession;
    }

    public byte[] getSequence() {
        return this.sequence;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public String getLocusName() {
        return this.locusName;
    }

    public String[] getAliases() {
        return this.aliases;
    }
}

