/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.dsi;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.exception.CodecLineParsingException;
import htsjdk.tribble.readers.LineIterator;
import org.broad.igv.Globals;
import org.broad.igv.feature.dsi.DSIFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.util.ParsingUtils;

public class DSICodec
extends AsciiFeatureCodec<DSIFeature> {
    private final Genome genome;
    private TrackProperties trackProperties;

    public DSICodec(Genome genome) {
        super(DSIFeature.class);
        this.genome = genome;
    }

    @Override
    public DSIFeature decode(String line) {
        String[] tokens2 = Globals.tabPattern.split(line);
        if (tokens2.length > 10) {
            String chr = this.genome == null ? tokens2[0].trim() : this.genome.getCanonicalChrName(tokens2[0].trim());
            DSIFeature feature = new DSIFeature();
            feature.chr = chr;
            feature.position = Integer.parseInt(tokens2[1]) - 1;
            feature.base = tokens2[2].charAt(0);
            feature.total = Integer.parseInt(tokens2[3]);
            feature.meth = Integer.parseInt(tokens2[4]);
            feature.unmeth = Integer.parseInt(tokens2[5]);
            feature.type = tokens2[6];
            feature.f = "NA".equals(tokens2[7]) ? Integer.MIN_VALUE : Integer.parseInt(tokens2[7]);
            feature.p = "NA".equals(tokens2[7]) ? Integer.MIN_VALUE : Integer.parseInt(tokens2[8]);
            feature.m = "NA".equals(tokens2[7]) ? Integer.MIN_VALUE : Integer.parseInt(tokens2[9]);
            feature.u = "NA".equals(tokens2[7]) ? Integer.MIN_VALUE : Integer.parseInt(tokens2[10]);
            return feature;
        }
        return null;
    }

    @Override
    public boolean canDecode(String path) {
        return path.toLowerCase().endsWith(".dsi") || path.toLowerCase().endsWith(".dsi.gz");
    }

    @Override
    public Object readActualHeader(LineIterator reader) {
        try {
            while (reader.hasNext()) {
                String line = reader.peek();
                if (line.startsWith("#")) {
                    reader.next();
                    continue;
                }
                if (!line.startsWith("#track") && !line.startsWith("##track")) break;
                this.trackProperties = new TrackProperties();
                ParsingUtils.parseTrackLine(line, this.trackProperties);
            }
            return this.trackProperties;
        }
        catch (Exception e) {
            throw new CodecLineParsingException("Error parsing header: " + e.getMessage(), e);
        }
    }
}

