/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.bedpe;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.broad.igv.util.ParsingUtils;

public class BedPEUtils {
    public static void main(String[] args) throws IOException {
        BedPEUtils.juiceboxToBedPE(args[0], args[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void interactionToBedPE(String ifile, String ofile) throws IOException {
        BufferedReader br = null;
        PrintWriter pw = null;
        try {
            String nextLine;
            br = new BufferedReader(new FileReader(ifile));
            pw = new PrintWriter(new BufferedWriter(new FileWriter(ofile)));
            while ((nextLine = br.readLine()) != null) {
                String[] tokens2 = ParsingUtils.WHITESPACE_PATTERN.split(nextLine);
                if (tokens2.length == 3) {
                    String[] t1 = tokens2[0].split(":");
                    String chr1 = t1[0];
                    t1 = t1[1].split("-");
                    String start1 = t1[0];
                    String end1 = t1[1];
                    t1 = tokens2[1].split(":");
                    String chr2 = t1[0];
                    t1 = t1[1].split("-");
                    String start2 = t1[0];
                    String end2 = t1[1];
                    String score = tokens2[2];
                    String name = tokens2[0] + "->" + tokens2[1];
                    pw.println(chr1 + "\t" + start1 + "\t" + end1 + "\t" + chr2 + "\t" + start2 + "\t" + end2 + "\t" + name + "\t" + score);
                    continue;
                }
                System.out.println("Skipping line: " + nextLine);
            }
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            if (br != null) {
                br.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void juiceboxToBedPE(String ifile, String ofile) throws IOException {
        BufferedReader br = null;
        PrintWriter pw = null;
        try {
            String nextLine;
            br = new BufferedReader(new FileReader(ifile));
            pw = new PrintWriter(new BufferedWriter(new FileWriter(ofile)));
            br.readLine();
            pw.println("#columns color=11;thickness=12");
            while ((nextLine = br.readLine()) != null) {
                if (nextLine.startsWith("#")) {
                    pw.println(nextLine);
                    continue;
                }
                String[] tokens2 = ParsingUtils.WHITESPACE_PATTERN.split(nextLine);
                if (tokens2.length >= 6) {
                    int i;
                    for (i = 0; i < 6; ++i) {
                        pw.print(tokens2[i] + "\t");
                    }
                    for (i = 0; i < 4; ++i) {
                        pw.print(".\t");
                    }
                    pw.println(tokens2[6] + "\t2\t");
                    continue;
                }
                System.out.println("Skipping line: " + nextLine);
            }
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            if (br != null) {
                br.close();
            }
        }
    }
}

