/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.seg;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.broad.igv.data.seg.SegmentedBinaryReader;
import org.broad.igv.data.seg.SegmentedChromosomeData;

public class SegmentedBinaryLocalReader
implements SegmentedBinaryReader {
    String filePath;
    List<String> chromosomes;
    List<String> sampleNames;
    Map<String, String> dataFileMap = new HashMap<String, String>();
    Map<String, String> attrs;

    public SegmentedBinaryLocalReader(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public List<String> getSampleNames() {
        if (this.sampleNames == null) {
            this.sampleNames = this.readAsStrings("data/samples.txt");
        }
        return this.sampleNames;
    }

    @Override
    public String getStringAttribute(String key) {
        return this.getAttributes().get(key);
    }

    public Map<String, String> getAttributes() {
        if (this.attrs == null) {
            this.attrs = new HashMap<String, String>();
            List<String> lines = this.readAsStrings("data/attributes.txt");
            if (lines != null) {
                for (String kv : lines) {
                    String[] tokens2 = kv.split("=");
                    this.attrs.put(tokens2[0], tokens2[1]);
                }
            }
        }
        return this.attrs;
    }

    @Override
    public SegmentedChromosomeData getChromosomeData(String chr) {
        return this.readChromosomeData(chr);
    }

    public int[] getStartLocations(String sample, String chr) {
        String entryName = "data/" + sample + "/" + chr + "/starts.bin";
        return this.readAsInts(entryName);
    }

    public int[] getEndLocations(String sample, String chr) {
        String entryName = "data/" + sample + "/" + chr + "/ends.bin";
        return this.readAsInts(entryName);
    }

    public float[] getValues(String sample, String chr) {
        String entryName = "data/" + sample + "/" + chr + "/values.bin";
        return this.readAsFloats(entryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readAsStrings(String entryName) {
        ArrayList<String> strings = new ArrayList<String>();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(new File(this.filePath));
            ZipEntry entry = zipFile.getEntry(entryName);
            if (entry == null) {
                List<String> list = null;
                return list;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry)));
            String nextLine = null;
            while ((nextLine = br.readLine()) != null) {
                strings.add(nextLine.trim());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
        return strings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentedChromosomeData readChromosomeData(String chr) {
        ZipFile zipFile = null;
        BufferedInputStream is = null;
        try {
            String entryName = "data/" + chr + ".bin";
            zipFile = new ZipFile(new File(this.filePath));
            ZipEntry entry = zipFile.getEntry(entryName);
            if (entry == null) {
                SegmentedChromosomeData segmentedChromosomeData = null;
                return segmentedChromosomeData;
            }
            is = new BufferedInputStream(zipFile.getInputStream(entry));
            SegmentedChromosomeData cd = new SegmentedChromosomeData();
            cd.deserialize(is);
            SegmentedChromosomeData segmentedChromosomeData = cd;
            return segmentedChromosomeData;
        }
        catch (IOException e) {
            e.printStackTrace();
            SegmentedChromosomeData segmentedChromosomeData = null;
            return segmentedChromosomeData;
        }
        finally {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] readAsInts(String entryName) {
        int[] nArray;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(new File(this.filePath));
            ZipEntry entry = zipFile.getEntry(entryName);
            if (entry == null) {
                int[] nArray2 = null;
                return nArray2;
            }
            DataInputStream is = new DataInputStream(new BufferedInputStream(zipFile.getInputStream(entry)));
            int nInts = (int)(entry.getSize() / 4L);
            int[] ints = new int[nInts];
            for (int i = 0; i < nInts; ++i) {
                ints[i] = is.readInt();
            }
            nArray = ints;
        }
        catch (IOException e) {
            e.printStackTrace();
            int[] nArray3 = null;
            return nArray3;
        }
        finally {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float[] readAsFloats(String entryName) {
        float[] fArray;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(new File(this.filePath));
            ZipEntry entry = zipFile.getEntry(entryName);
            if (entry == null) {
                float[] fArray2 = null;
                return fArray2;
            }
            DataInputStream is = new DataInputStream(new BufferedInputStream(zipFile.getInputStream(entry)));
            int nInts = (int)(entry.getSize() / 4L);
            float[] values2 = new float[nInts];
            for (int i = 0; i < nInts; ++i) {
                values2[i] = is.readFloat();
            }
            fArray = values2;
        }
        catch (IOException e) {
            e.printStackTrace();
            float[] fArray3 = null;
            return fArray3;
        }
        finally {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
        return fArray;
    }
}

