/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.seg;

import htsjdk.tribble.readers.AsciiLineReader;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.data.seg.SegFileParser;
import org.broad.igv.data.seg.SegmentedAsciiDataSet;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.exceptions.ParserException;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class SegmentFileParser
implements SegFileParser {
    private static Logger log = Logger.getLogger(SegmentFileParser.class);
    boolean birdsuite = false;
    int sampleColumn = 0;
    int chrColumn = 1;
    int startColumn = 2;
    int endColumn = 3;
    int dataColumn = 5;
    ResourceLocator locator;

    public SegmentFileParser(ResourceLocator locator) {
        this.locator = locator;
        if (locator.getPath().toLowerCase().endsWith("birdseye_canary_calls")) {
            this.birdsuite = true;
        }
    }

    @Override
    public SegmentedAsciiDataSet loadSegments(ResourceLocator locator, Genome genome) {
        SegmentedAsciiDataSet dataset = new SegmentedAsciiDataSet(genome);
        if (this.birdsuite) {
            dataset.setTrackType(TrackType.CNV);
        }
        AsciiLineReader reader = null;
        String nextLine = null;
        int lineNumber = 0;
        try {
            reader = ParsingUtils.openAsciiReader(locator);
            nextLine = reader.readLine();
            while (nextLine.startsWith("#") || nextLine.trim().length() == 0) {
                ++lineNumber;
                if (nextLine.length() > 0) {
                    this.parseComment(nextLine, dataset);
                }
                nextLine = reader.readLine();
            }
            String[] headings = nextLine.split("\t");
            if (this.birdsuite) {
                this.sampleColumn = 0;
                this.dataColumn = 2;
                this.chrColumn = 3;
                this.startColumn = 4;
                this.endColumn = 5;
            } else {
                this.sampleColumn = 0;
                this.chrColumn = 1;
                this.startColumn = 2;
                this.endColumn = 3;
                this.dataColumn = headings.length - 1;
            }
            while ((nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                int end;
                int start;
                ++lineNumber;
                String[] tokens2 = Globals.tabPattern.split(nextLine, -1);
                int nTokens = tokens2.length;
                if (nTokens <= 4) continue;
                try {
                    start = ParsingUtils.parseInt(tokens2[this.startColumn].trim());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParserException("Column " + (this.startColumn + 1) + " must contain a numeric value.", lineNumber, nextLine);
                }
                try {
                    end = ParsingUtils.parseInt(tokens2[this.endColumn].trim());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParserException("Column " + (this.endColumn + 1) + " must contain a numeric value.", lineNumber, nextLine);
                }
                String chr = tokens2[this.chrColumn].trim();
                if (genome != null) {
                    chr = genome.getCanonicalChrName(chr);
                }
                String trackId = new String(tokens2[this.sampleColumn].trim());
                StringBuffer desc = null;
                if (this.birdsuite) {
                    desc = new StringBuffer();
                    desc.append("<br>");
                    desc.append(headings[6]);
                    desc.append("=");
                    desc.append(tokens2[6]);
                } else if (tokens2.length > 4) {
                    desc = new StringBuffer();
                    for (int i = 4; i < headings.length - 1; ++i) {
                        desc.append("<br>");
                        desc.append(headings[i]);
                        desc.append(": ");
                        desc.append(tokens2[i]);
                    }
                }
                try {
                    float value = Float.parseFloat(tokens2[this.dataColumn]);
                    String description = desc == null ? null : desc.toString();
                    dataset.addSegment(trackId, chr, start, end, value, description);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (DataLoadException pe) {
            throw pe;
        }
        catch (ParserException pe) {
            throw pe;
        }
        catch (Exception e) {
            if (nextLine != null && lineNumber != 0) {
                throw new ParserException(e.getMessage(), (Throwable)e, lineNumber, nextLine);
            }
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        dataset.sortLists();
        return dataset;
    }

    private void parseComment(String comment, SegmentedAsciiDataSet dataset) {
        String tmp = comment.substring(1, comment.length());
        if (tmp.startsWith("track")) {
            ParsingUtils.parseTrackLine(tmp, dataset.getTrackProperties());
        } else {
            String[] tokens2 = tmp.split("=");
            String key = tokens2[0].trim().toLowerCase();
            if (key.equals("type")) {
                if (tokens2.length != 2) {
                    return;
                }
                try {
                    dataset.setTrackType(TrackType.valueOf(tokens2[1].trim().toUpperCase()));
                }
                catch (Exception exception) {
                    log.error("Unknown track type: " + tokens2[1].trim().toUpperCase());
                }
            }
        }
    }

    static enum Type {
        SEG,
        BIRDSUITE,
        NEXUS;

    }
}

