/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.cufflinks;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.Feature;
import htsjdk.tribble.readers.LineIterator;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.util.ParsingUtils;

public abstract class CufflinksCodec<T extends Feature>
extends AsciiFeatureCodec<T> {
    private static Logger log = Logger.getLogger(CufflinksCodec.class);
    String path;

    protected CufflinksCodec(Class<T> clazz, String path) {
        super(clazz);
        this.path = path;
    }

    protected abstract Object readHeader(String[] var1);

    @Override
    public Object readActualHeader(LineIterator reader) {
        String headerLine = null;
        try {
            headerLine = (String)reader.next();
            String[] tokens2 = ParsingUtils.TAB_PATTERN.split(headerLine);
            return this.readHeader(tokens2);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new DataLoadException("Error reading header: " + e.getMessage(), this.path);
        }
    }
}

