/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.util.CollectionUtils;
import org.apache.tools.ant.util.DOMElementWriter;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EchoProperties
extends Task {
    private static final String PROPERTIES = "properties";
    private static final String PROPERTY = "property";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VALUE = "value";
    private File inFile = null;
    private File destfile = null;
    private boolean failonerror = true;
    private Vector propertySets = new Vector();
    private String format = "text";
    private String prefix;
    private String regex;

    public void setSrcfile(File file) {
        this.inFile = file;
    }

    public void setDestfile(File destfile) {
        this.destfile = destfile;
    }

    public void setFailOnError(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public void setPrefix(String prefix) {
        if (prefix != null && prefix.length() != 0) {
            this.prefix = prefix;
            PropertySet ps = new PropertySet();
            ps.setProject(this.getProject());
            ps.appendPrefix(prefix);
            this.addPropertyset(ps);
        }
    }

    public void setRegex(String regex) {
        if (regex != null && regex.length() != 0) {
            this.regex = regex;
            PropertySet ps = new PropertySet();
            ps.setProject(this.getProject());
            ps.appendRegex(regex);
            this.addPropertyset(ps);
        }
    }

    public void addPropertyset(PropertySet ps) {
        this.propertySets.addElement(ps);
    }

    public void setFormat(FormatAttribute ea) {
        this.format = ea.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        if (this.prefix != null && this.regex != null) {
            throw new BuildException("Please specify either prefix or regex, but not both", this.getLocation());
        }
        allProps = new Hashtable<Object, Object>();
        if (this.inFile == null && this.propertySets.size() == 0) {
            allProps.putAll(this.getProject().getProperties());
        } else if (this.inFile != null) {
            if (this.inFile.exists() && this.inFile.isDirectory()) {
                message = "srcfile is a directory!";
                if (this.failonerror) {
                    throw new BuildException(message, this.getLocation());
                }
                this.log(message, 0);
                return;
            }
            if (this.inFile.exists() && !this.inFile.canRead()) {
                message = "Can not read from the specified srcfile!";
                if (this.failonerror) {
                    throw new BuildException(message, this.getLocation());
                }
                this.log(message, 0);
                return;
            }
            in = null;
            try {
                in = new FileInputStream(this.inFile);
                props = new Properties();
                props.load(in);
                allProps.putAll(props);
            }
            catch (FileNotFoundException fnfe) {
                message = "Could not find file " + this.inFile.getAbsolutePath();
                if (this.failonerror) {
                    throw new BuildException(message, fnfe, this.getLocation());
                }
                this.log(message, 1);
                {
                    catch (Throwable var5_13) {
                        FileUtils.close(in);
                        throw var5_13;
                    }
                }
                FileUtils.close(in);
                return;
                catch (IOException ioe) {
                    message = "Could not read file " + this.inFile.getAbsolutePath();
                    if (this.failonerror) {
                        throw new BuildException(message, ioe, this.getLocation());
                    }
                    this.log(message, 1);
                    FileUtils.close(in);
                    return;
                }
            }
            FileUtils.close(in);
        }
        e = this.propertySets.elements();
        while (e.hasMoreElements()) {
            ps = (PropertySet)e.nextElement();
            allProps.putAll(ps.getProperties());
        }
        os = null;
        try {
            block34: {
                try {
                    if (this.destfile == null) {
                        os = new ByteArrayOutputStream();
                        this.saveProperties(allProps, os);
                        this.log(os.toString(), 2);
                        break block34;
                    }
                    if (this.destfile.exists() && this.destfile.isDirectory()) {
                        message = "destfile is a directory!";
                        if (this.failonerror) {
                            throw new BuildException(message, this.getLocation());
                        }
                        this.log(message, 0);
                        var7_14 = null;
                        if (os == null) return;
                        try {
                            os.close();
                            return;
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                        return;
                    }
                    if (this.destfile.exists() && !this.destfile.canWrite()) {
                        message = "Can not write to the specified destfile!";
                        if (this.failonerror) {
                            throw new BuildException(message, this.getLocation());
                        }
                        this.log(message, 0);
                        var7_15 = null;
                        if (os == null) return;
                        ** try [egrp 5[TRYBLOCK] [14 : 608->615)] { 
lbl84:
                        // 1 sources

                        os.close();
                        return;
lbl86:
                        // 1 sources

                        catch (IOException ex) {
                            // empty catch block
                        }
                        return;
                    }
                    os = new FileOutputStream(this.destfile);
                    this.saveProperties(allProps, os);
                }
                catch (IOException ioe) {
                    if (this.failonerror) {
                        throw new BuildException(ioe, this.getLocation());
                    }
                    this.log(ioe.getMessage(), 2);
                    var7_17 = null;
                    if (os == null) return;
                    try {}
                    catch (IOException ex) {
                        return;
                    }
                    os.close();
                    return;
                }
            }
            var7_16 = null;
            if (os == null) return;
            try {}
            catch (IOException ex) {
                return;
            }
            os.close();
            return;
        }
        catch (Throwable var6_24) {
            var7_18 = null;
            if (os == null) throw var6_24;
            ** try [egrp 5[TRYBLOCK] [14 : 608->615)] { 
lbl117:
            // 1 sources

            os.close();
            throw var6_24;
lbl119:
            // 1 sources

            catch (IOException ex) {
                // empty catch block
            }
            throw var6_24;
        }
    }

    protected void saveProperties(Hashtable allProps, OutputStream os) throws IOException, BuildException {
        final ArrayList keyList = new ArrayList(allProps.keySet());
        Collections.sort(keyList);
        Properties props = new Properties(){
            private static final long serialVersionUID = 5090936442309201654L;

            public Enumeration keys() {
                return CollectionUtils.asEnumeration(keyList.iterator());
            }

            public Set entrySet() {
                Set<Map.Entry<Object, Object>> result = super.entrySet();
                if (JavaEnvUtils.isKaffe()) {
                    TreeSet<Map.Entry<Object, Object>> t = new TreeSet<Map.Entry<Object, Object>>(new Comparator(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public int compare(Object o1, Object o2) {
                            String key1 = (String)((Map.Entry)o1).getKey();
                            String key2 = (String)((Map.Entry)o2).getKey();
                            return key1.compareTo(key2);
                        }
                    });
                    t.addAll(result);
                    result = t;
                }
                return result;
            }
        };
        int size = keyList.size();
        for (int i = 0; i < size; ++i) {
            String name = keyList.get(i).toString();
            String value = allProps.get(name).toString();
            props.setProperty(name, value);
        }
        if ("text".equals(this.format)) {
            this.jdkSaveProperties(props, os, "Ant properties");
        } else if ("xml".equals(this.format)) {
            this.xmlSaveProperties(props, os);
        }
    }

    private List sortProperties(Properties props) {
        ArrayList<Tuple> sorted2 = new ArrayList<Tuple>(props.size());
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            sorted2.add(new Tuple(name, props.getProperty(name)));
        }
        Collections.sort(sorted2);
        return sorted2;
    }

    protected void xmlSaveProperties(Properties props, OutputStream os) throws IOException {
        Document doc = EchoProperties.getDocumentBuilder().newDocument();
        Element rootElement = doc.createElement(PROPERTIES);
        List sorted2 = this.sortProperties(props);
        Iterator iten = sorted2.iterator();
        while (iten.hasNext()) {
            Tuple tuple = (Tuple)iten.next();
            Element propElement = doc.createElement(PROPERTY);
            propElement.setAttribute(ATTR_NAME, tuple.key);
            propElement.setAttribute(ATTR_VALUE, tuple.value);
            rootElement.appendChild(propElement);
        }
        OutputStreamWriter wri = null;
        try {
            wri = new OutputStreamWriter(os, "UTF8");
            wri.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            new DOMElementWriter().write(rootElement, wri, 0, "\t");
            ((Writer)wri).flush();
        }
        catch (IOException ioe) {
            try {
                throw new BuildException("Unable to write XML file", ioe);
            }
            catch (Throwable throwable) {
                FileUtils.close(wri);
                throw throwable;
            }
        }
        FileUtils.close(wri);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void jdkSaveProperties(Properties props, OutputStream os, String header) throws IOException {
        props.store(os, header);
        Object var6_4 = null;
        if (os == null) return;
        try {
            os.close();
            return;
        }
        catch (IOException ioex) {
            this.log("Failed to close output stream");
        }
        return;
        {
            catch (IOException ioe) {
                throw new BuildException(ioe, this.getLocation());
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (os == null) throw throwable;
            try {
                os.close();
                throw throwable;
            }
            catch (IOException ioex) {
                this.log("Failed to close output stream");
            }
            throw throwable;
        }
    }

    private static DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static final class Tuple
    implements Comparable {
        private String key;
        private String value;

        private Tuple(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public int compareTo(Object o) {
            Tuple that = (Tuple)o;
            return this.key.compareTo(that.key);
        }
    }

    public static class FormatAttribute
    extends EnumeratedAttribute {
        private String[] formats = new String[]{"xml", "text"};

        public String[] getValues() {
            return this.formats;
        }
    }
}

