/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.summary;

import java.io.Serializable;
import org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;

public class Sum
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -8231831954703408316L;
    private long n;
    private double value;

    public Sum() {
        this.n = 0L;
        this.value = Double.NaN;
    }

    public Sum(Sum original) {
        Sum.copy(original, this);
    }

    public void increment(double d) {
        this.value = this.n == 0L ? d : (this.value += d);
        ++this.n;
    }

    public double getResult() {
        return this.value;
    }

    public long getN() {
        return this.n;
    }

    public void clear() {
        this.value = Double.NaN;
        this.n = 0L;
    }

    public double evaluate(double[] values2, int begin, int length) {
        double sum = Double.NaN;
        if (this.test(values2, begin, length)) {
            sum = 0.0;
            for (int i = begin; i < begin + length; ++i) {
                sum += values2[i];
            }
        }
        return sum;
    }

    public double evaluate(double[] values2, double[] weights, int begin, int length) {
        double sum = Double.NaN;
        if (this.test(values2, weights, begin, length)) {
            sum = 0.0;
            for (int i = begin; i < begin + length; ++i) {
                sum += values2[i] * weights[i];
            }
        }
        return sum;
    }

    public double evaluate(double[] values2, double[] weights) {
        return this.evaluate(values2, weights, 0, values2.length);
    }

    public Sum copy() {
        Sum result = new Sum();
        Sum.copy(this, result);
        return result;
    }

    public static void copy(Sum source, Sum dest) {
        dest.setData(source.getDataRef());
        dest.n = source.n;
        dest.value = source.value;
    }
}

