/*
 * Decompiled with CFR 0.152.
 */
package javastraw.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.List;
import javastraw.StrawGlobals;

public class UNIXTools {
    public static String extractElement(String str, int i) {
        String[] strSplit = str.split("\t");
        return strSplit[strSplit.length - i];
    }

    public static String makeDir(String path) {
        File file = new File(path);
        if (!file.isDirectory()) {
            file.mkdir();
        }
        return path;
    }

    public static File makeDir(File folder) {
        if (!folder.isDirectory()) {
            folder.mkdir();
        }
        return folder;
    }

    public static void redirectOutput(List<String> command, String outputFilePath) {
        String output = UNIXTools.executeComplexCommand(command);
        File outputFile = new File(outputFilePath);
        try {
            outputFile.createNewFile();
            PrintWriter writer = new PrintWriter(outputFile);
            writer.print(output);
            writer.close();
        }
        catch (Exception e) {
            System.err.println("Unable to write command line output to file: " + outputFilePath);
            e.printStackTrace();
        }
    }

    public static String executeSimpleCommand(String command) {
        StringBuilder output = new StringBuilder();
        try {
            String line;
            Process p = Runtime.getRuntime().exec(command);
            p.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()), 0x200000);
            while ((line = reader.readLine()) != null) {
                output.append(line).append("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return output.toString();
    }

    private static String executeComplexCommand(List<String> command) {
        StringBuilder output = new StringBuilder();
        ProcessBuilder b = new ProcessBuilder(command);
        try {
            String line;
            Process p = b.redirectErrorStream(true).start();
            if (StrawGlobals.printVerboseComments) {
                System.out.println("Command exec " + p.waitFor());
            } else {
                p.waitFor();
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()), 0x200000);
            while ((line = reader.readLine()) != null) {
                output.append(line).append("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return output.toString();
    }
}

