/*
 * Decompiled with CFR 0.152.
 */
package javastraw.tools;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javastraw.StrawGlobals;

public class ParallelizationTools {
    public static void launchParallelizedCode(Runnable runnable) {
        ParallelizationTools.launchParallelizedCode(Runtime.getRuntime().availableProcessors(), runnable);
    }

    public static void launchParallelizedCode(int numCPUThreads, final Runnable runnable) {
        ExecutorService executor = Executors.newFixedThreadPool(numCPUThreads);
        for (int l = 0; l < numCPUThreads; ++l) {
            Runnable worker = new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                }
            };
            executor.execute(worker);
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
    }

    public static void shutDownServiceAndWait(ExecutorService service, AtomicInteger errorCounter) {
        block3: {
            service.shutdown();
            try {
                service.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException e) {
                System.err.println("Error loading mzd data " + e.getLocalizedMessage());
                if (!StrawGlobals.printVerboseComments) break block3;
                e.printStackTrace();
            }
        }
        if (errorCounter.get() > 0) {
            System.err.println(errorCounter.get() + " errors while reading blocks");
        }
    }
}

