/*
 * Decompiled with CFR 0.152.
 */
package javastraw.tools;

import java.io.IOException;
import java.util.List;
import javastraw.reader.block.Block;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.expected.ExpectedValueFunction;
import javastraw.reader.mzd.MatrixZoomData;
import javastraw.reader.type.NormalizationType;
import javastraw.tools.HiCFileTools;
import org.apache.commons.math3.linear.RealMatrix;

public class ExtractingOEDataUtils {
    private static final double e = Math.exp(1.0);

    public static float[][] simpleLog(float[][] matrix, float pseudocount) {
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                float val = matrix[i][j];
                if (Float.isNaN(val)) continue;
                matrix[i][j] = (float)Math.log(val + pseudocount);
            }
        }
        return matrix;
    }

    public static float[][] simpleLogWithCleanup(float[][] matrix, float pseudocount) {
        matrix = ExtractingOEDataUtils.simpleLog(matrix, pseudocount);
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                if (!Float.isInfinite(matrix[i][j]) && !((double)Math.abs(matrix[i][j]) < 1.0E-10)) continue;
                matrix[i][j] = Float.NaN;
            }
        }
        return matrix;
    }

    public static float[][] logOEP1(float[][] matrix, double averageCount) {
        double denom = Math.log(averageCount + e);
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                matrix[i][j] = (float)(Math.log((double)matrix[i][j] + e) / denom);
            }
        }
        return matrix;
    }

    public static float[][] extractObsOverExpBoundedRegion(MatrixZoomData zd, int binXStart, int binXEnd, int binYStart, int binYEnd, int numRows, int numCols, NormalizationType normalizationType, ExpectedValueFunction df, int chrIndex, double threshold, boolean isIntraFillUnderDiagonal, ThresholdType thresholdType, float pseudocount, float invalidReplacement) throws IOException {
        if (isIntraFillUnderDiagonal && df == null) {
            System.err.println("DF is null");
            return null;
        }
        List<Block> blocks = HiCFileTools.getAllRegionBlocks(zd, binXStart, binXEnd, binYStart, binYEnd, normalizationType, isIntraFillUnderDiagonal);
        float[][] data = new float[numRows][numCols];
        double averageCount = zd.getAverageCount() / 2.0;
        if (blocks.size() > 0) {
            for (Block b : blocks) {
                if (b == null) continue;
                for (ContactRecord rec : b.getContactRecords()) {
                    double expected = ExtractingOEDataUtils.getExpected(rec, df, chrIndex, isIntraFillUnderDiagonal, averageCount);
                    double val = rec.getCounts();
                    double observed = val + (double)pseudocount;
                    expected += (double)pseudocount;
                    double answer = Double.NaN;
                    if (thresholdType.equals((Object)ThresholdType.LOG_BASE_EXP_OF_OBS)) {
                        answer = Math.log(observed) / Math.log(expected);
                    } else if (thresholdType.equals((Object)ThresholdType.TRUE_OE_LOG) || thresholdType.equals((Object)ThresholdType.LOG_OE_BOUNDED) || thresholdType.equals((Object)ThresholdType.LOG_OE_BOUNDED_SCALED_BTWN_ZERO_ONE)) {
                        answer = Math.log(observed / expected);
                        if (thresholdType.equals((Object)ThresholdType.LOG_OE_BOUNDED)) {
                            answer = Math.min(Math.max(-threshold, answer), threshold);
                        } else if (thresholdType.equals((Object)ThresholdType.LOG_OE_BOUNDED_SCALED_BTWN_ZERO_ONE)) {
                            answer = Math.min(Math.max(-threshold, answer), threshold);
                            answer = (answer + threshold) / (2.0 * threshold);
                        }
                    } else if (thresholdType.equals((Object)ThresholdType.TRUE_OE) || thresholdType.equals((Object)ThresholdType.TRUE_OE_LINEAR)) {
                        answer = observed / expected;
                        if (thresholdType.equals((Object)ThresholdType.TRUE_OE_LINEAR)) {
                            answer = answer < 1.0 ? 1.0 - 1.0 / answer : (answer -= 1.0);
                        }
                    }
                    float floatAnswer = (float)answer;
                    if (Float.isNaN(floatAnswer) || Float.isInfinite(floatAnswer)) {
                        floatAnswer = invalidReplacement;
                    }
                    ExtractingOEDataUtils.placeOEValInRelativePosition(floatAnswer, rec, binXStart, binYStart, numRows, numCols, data, isIntraFillUnderDiagonal);
                }
            }
        }
        blocks = null;
        return data;
    }

    private static void placeOEValInRelativePosition(double oeVal, ContactRecord rec, int binXStart, int binYStart, int numRows, int numCols, RealMatrix data, boolean isIntra) {
        int relativeX = rec.getBinX() - binXStart;
        int relativeY = rec.getBinY() - binYStart;
        if (relativeX >= 0 && relativeX < numRows && relativeY >= 0 && relativeY < numCols) {
            data.addToEntry(relativeX, relativeY, oeVal);
        }
        if (isIntra) {
            relativeX = rec.getBinY() - binXStart;
            relativeY = rec.getBinX() - binYStart;
            if (relativeX >= 0 && relativeX < numRows && relativeY >= 0 && relativeY < numCols) {
                data.addToEntry(relativeX, relativeY, oeVal);
            }
        }
    }

    private static void placeOEValInRelativePosition(float oeVal, ContactRecord rec, int binXStart, int binYStart, int numRows, int numCols, float[][] data, boolean isIntra) {
        int relativeX = rec.getBinX() - binXStart;
        int relativeY = rec.getBinY() - binYStart;
        if (relativeX >= 0 && relativeX < numRows && relativeY >= 0 && relativeY < numCols) {
            data[relativeX][relativeY] = oeVal;
        }
        if (isIntra) {
            relativeX = rec.getBinY() - binXStart;
            relativeY = rec.getBinX() - binYStart;
            if (relativeX >= 0 && relativeX < numRows && relativeY >= 0 && relativeY < numCols) {
                data[relativeX][relativeY] = oeVal;
            }
        }
    }

    private static double getExpected(ContactRecord rec, ExpectedValueFunction df, int chrIndex, boolean isIntra, double averageCount) {
        double expected;
        int x = rec.getBinX();
        int y = rec.getBinY();
        if (isIntra) {
            int dist = Math.abs(x - y);
            expected = df.getExpectedValue(chrIndex, dist);
        } else {
            expected = averageCount > 0.0 ? averageCount : 1.0;
        }
        return expected;
    }

    public static enum ThresholdType {
        LOG_BASE_EXP_OF_OBS,
        LOG_OE_BOUNDED,
        TRUE_OE,
        TRUE_OE_LOG,
        TRUE_OE_LINEAR,
        LOG_OE_BOUNDED_SCALED_BTWN_ZERO_ONE;

    }
}

