/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.norm;

import javastraw.reader.datastructures.ListOfDoubleArrays;
import javastraw.reader.type.HiCZoom;
import javastraw.reader.type.NormalizationType;

public class NormalizationVector {
    protected final NormalizationType type;
    protected final int chrIdx;
    protected final HiCZoom.HiCUnit unit;
    protected final int resolution;
    protected final ListOfDoubleArrays data;

    public NormalizationVector(NormalizationType type, int chrIdx, HiCZoom.HiCUnit unit, int resolution, ListOfDoubleArrays data) {
        this.type = type;
        this.chrIdx = chrIdx;
        this.unit = unit;
        this.resolution = resolution;
        this.data = data;
    }

    public static String getKey(NormalizationType type, int chrIdx, String unit, int resolution) {
        return type + "_" + chrIdx + "_" + unit + "_" + resolution;
    }

    public int getChrIdx() {
        return this.chrIdx;
    }

    public int getResolution() {
        return this.resolution;
    }

    public String getKey() {
        return NormalizationVector.getKey(this.type, this.chrIdx, this.unit.toString(), this.resolution);
    }

    public ListOfDoubleArrays getData() {
        return this.data;
    }
}

