/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.mzd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javastraw.matrices.BasicMatrix;
import javastraw.reader.DatasetReader;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.block.Block;
import javastraw.reader.block.BlockModifier;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.block.IdentityModifier;
import javastraw.reader.depth.LogDepth;
import javastraw.reader.depth.V9Depth;
import javastraw.reader.expected.ExpectedValueFunction;
import javastraw.reader.iterators.IteratorContainer;
import javastraw.reader.iterators.ListOfListGenerator;
import javastraw.reader.iterators.ZDIteratorContainer;
import javastraw.reader.mzd.DynamicMatrixZoomData;
import javastraw.reader.pearsons.PearsonsManager;
import javastraw.reader.type.HiCZoom;
import javastraw.reader.type.NormalizationType;
import javastraw.tools.ParallelizationTools;
import org.broad.igv.util.collections.LRUCache;

public class MatrixZoomData {
    protected final Chromosome chr1;
    protected final Chromosome chr2;
    protected final boolean isIntra;
    protected final HiCZoom zoom;
    protected final int blockBinCount;
    protected final int blockColumnCount;
    protected final long correctedBinCount;
    protected final LRUCache<String, Block> blockCache;
    protected final V9Depth v9Depth;
    protected final Map<NormalizationType, BasicMatrix> pearsonsMap;
    protected DatasetReader reader;
    protected final Map<String, double[]> eigenvectorMap;
    protected final BlockModifier identity = new IdentityModifier();
    protected double averageCount = -1.0;
    protected IteratorContainer iteratorContainer = null;
    public static boolean useIteratorDontPutAllInRAM = false;
    public static boolean shouldCheckRAMUsage = false;
    protected boolean useCache = true;

    public MatrixZoomData(Chromosome chr1, Chromosome chr2, HiCZoom zoom, int blockBinCount, int blockColumnCount, int[] chr1Sites, int[] chr2Sites, DatasetReader reader) {
        this.chr1 = chr1;
        this.chr2 = chr2;
        this.zoom = zoom;
        this.isIntra = chr1.getIndex() == chr2.getIndex();
        this.reader = reader;
        this.blockBinCount = blockBinCount;
        this.blockCache = new LRUCache(500);
        this.v9Depth = reader.getVersion() > 8 ? V9Depth.setDepthMethod(reader.getDepthBase(), blockBinCount) : new LogDepth(2, blockBinCount);
        this.blockColumnCount = blockColumnCount;
        if (!(this instanceof DynamicMatrixZoomData)) {
            if (reader.getVersion() < 8 && chr1.getLength() < chr2.getLength()) {
                boolean isFrag = zoom.getUnit() == HiCZoom.HiCUnit.FRAG;
                long len1 = chr1.getLength();
                long len2 = chr2.getLength();
                if (chr1Sites != null && chr2Sites != null && isFrag) {
                    len1 = chr1Sites.length + 1;
                    len2 = chr2Sites.length + 1;
                }
                long nBinsX = Math.max(len1, len2) / (long)zoom.getBinSize() + 1L;
                this.correctedBinCount = nBinsX / (long)blockColumnCount + 1L;
            } else {
                this.correctedBinCount = blockBinCount;
            }
        } else {
            this.correctedBinCount = blockBinCount;
        }
        this.pearsonsMap = new HashMap<NormalizationType, BasicMatrix>();
        this.eigenvectorMap = new HashMap<String, double[]>();
    }

    protected MatrixZoomData(MatrixZoomData zd0) {
        this.chr1 = zd0.chr1;
        this.chr2 = zd0.chr2;
        this.isIntra = zd0.isIntra;
        this.zoom = zd0.zoom;
        this.blockBinCount = zd0.blockBinCount;
        this.blockColumnCount = zd0.blockColumnCount;
        this.correctedBinCount = zd0.correctedBinCount;
        this.blockCache = zd0.blockCache;
        this.v9Depth = zd0.v9Depth;
        this.averageCount = zd0.averageCount;
        this.reader = zd0.reader;
        this.iteratorContainer = zd0.iteratorContainer;
        this.useCache = zd0.useCache;
        this.pearsonsMap = zd0.pearsonsMap;
        this.eigenvectorMap = zd0.eigenvectorMap;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public Chromosome getChr1() {
        return this.chr1;
    }

    public Chromosome getChr2() {
        return this.chr2;
    }

    public int getBinSize() {
        return this.zoom.getBinSize();
    }

    public int getChr1Idx() {
        return this.chr1.getIndex();
    }

    public int getChr2Idx() {
        return this.chr2.getIndex();
    }

    public long getMatrixSize() {
        return this.chr1.getLength() / (long)this.zoom.getBinSize() + 1L;
    }

    public long getCorrectedBinCount() {
        return this.correctedBinCount;
    }

    public int getBlockBinCount() {
        return this.blockBinCount;
    }

    public HiCZoom getZoom() {
        return this.zoom;
    }

    public int getBlockColumnCount() {
        return this.blockColumnCount;
    }

    public String getKey() {
        return this.chr1.getName() + "_" + this.chr2.getName() + "_" + this.zoom.getKey();
    }

    public String getKey(int chr1, int chr2) {
        return chr1 + "_" + chr2 + "_" + this.zoom.getKey();
    }

    public String getBlockKey(int blockNumber, NormalizationType no) {
        return this.getKey() + "_" + blockNumber + "_" + no;
    }

    public String getNormLessBlockKey(Block block) {
        return this.getKey() + "_" + block.getNumber() + "_" + block.getUniqueRegionID();
    }

    public List<Block> getNormalizedBlocksOverlapping(long binX1, long binY1, long binX2, long binY2, NormalizationType no, boolean isImportant, boolean fillUnderDiagonal) {
        return this.getNormalizedBlocksOverlapping(binX1, binY1, binX2, binY2, no, isImportant, fillUnderDiagonal, this.identity);
    }

    public List<Block> getNormalizedBlocksOverlapping(long binX1, long binY1, long binX2, long binY2, NormalizationType no, boolean isImportant, boolean fillUnderDiagonal, BlockModifier modifier) {
        List<Block> blockList = Collections.synchronizedList(new ArrayList());
        if (this.reader.getVersion() > 8 && this.isIntra) {
            return this.addNormalizedBlocksToListV9(blockList, (int)binX1, (int)binY1, (int)binX2, (int)binY2, no, modifier);
        }
        return this.addNormalizedBlocksToList(blockList, (int)binX1, (int)binY1, (int)binX2, (int)binY2, no, fillUnderDiagonal, modifier);
    }

    public int getBlockNumberVersion9FromPADAndDepth(int positionAlongDiagonal, int depth) {
        return depth * this.blockColumnCount + positionAlongDiagonal;
    }

    protected void populateBlocksToLoadV9(int positionAlongDiagonal, int depth, NormalizationType no, List<Block> blockList, Set<Integer> blocksToLoad) {
        int blockNumber = this.getBlockNumberVersion9FromPADAndDepth(positionAlongDiagonal, depth);
        String key = this.getBlockKey(blockNumber, no);
        if (this.useCache && this.blockCache.containsKey(key)) {
            Block b = this.blockCache.get(key);
            blockList.add(b);
        } else {
            blocksToLoad.add(blockNumber);
        }
    }

    protected List<Block> addNormalizedBlocksToListV9(List<Block> blockList, int binX1, int binY1, int binX2, int binY2, NormalizationType norm, BlockModifier modifier) {
        HashSet<Integer> blocksToLoad = new HashSet<Integer>();
        int translatedLowerPAD = (binX1 + binY1) / 2 / this.blockBinCount;
        int translatedHigherPAD = (binX2 + binY2) / 2 / this.blockBinCount + 1;
        int translatedNearerDepth = this.v9Depth.getDepth(binX1, binY2);
        int translatedFurtherDepth = this.v9Depth.getDepth(binX2, binY1);
        int nearerDepth = Math.min(translatedNearerDepth, translatedFurtherDepth);
        if (binX1 > binY2 && binX2 < binY1 || binX2 > binY1 && binX1 < binY2) {
            nearerDepth = 0;
        }
        int furtherDepth = Math.max(translatedNearerDepth, translatedFurtherDepth) + 1;
        for (int depth = nearerDepth; depth <= furtherDepth; ++depth) {
            for (int pad = translatedLowerPAD; pad <= translatedHigherPAD; ++pad) {
                this.populateBlocksToLoadV9(pad, depth, norm, blockList, blocksToLoad);
            }
        }
        this.actuallyLoadGivenBlocks(blockList, blocksToLoad, norm, modifier);
        return new ArrayList<Block>(new HashSet<Block>(blockList));
    }

    protected void populateBlocksToLoad(int r, int c, NormalizationType no, List<Block> blockList, Set<Integer> blocksToLoad) {
        int blockNumber = r * this.getBlockColumnCount() + c;
        String key = this.getBlockKey(blockNumber, no);
        if (this.useCache && this.blockCache.containsKey(key)) {
            Block b = this.blockCache.get(key);
            blockList.add(b);
        } else {
            blocksToLoad.add(blockNumber);
        }
    }

    protected List<Block> addNormalizedBlocksToList(List<Block> blockList, int binX1, int binY1, int binX2, int binY2, NormalizationType norm, boolean getBelowDiagonal, BlockModifier modifier) {
        int c;
        int r;
        HashSet<Integer> blocksToLoad = new HashSet<Integer>();
        int col1 = binX1 / this.blockBinCount;
        int row1 = binY1 / this.blockBinCount;
        int col2 = binX2 / this.blockBinCount;
        int row2 = binY2 / this.blockBinCount;
        for (r = row1; r <= row2; ++r) {
            for (c = col1; c <= col2; ++c) {
                this.populateBlocksToLoad(r, c, norm, blockList, blocksToLoad);
            }
        }
        if (getBelowDiagonal && binY1 < binX2) {
            for (r = row1; r <= row2; ++r) {
                for (c = col1; c <= col2; ++c) {
                    this.populateBlocksToLoad(c, r, norm, blockList, blocksToLoad);
                }
            }
        }
        this.actuallyLoadGivenBlocks(blockList, blocksToLoad, norm, modifier);
        return new ArrayList<Block>(new HashSet<Block>(blockList));
    }

    protected void actuallyLoadGivenBlocks(List<Block> blockList, Set<Integer> blocksToLoad, NormalizationType no, BlockModifier modifier) {
        AtomicInteger errorCounter = new AtomicInteger();
        ExecutorService service = Executors.newFixedThreadPool(200);
        for (int blockNumber : blocksToLoad) {
            String key = this.getBlockKey(blockNumber, no);
            this.readBlockUpdateListAndCache(blockNumber, this.reader, no, blockList, key, errorCounter, service, modifier);
        }
        ParallelizationTools.shutDownServiceAndWait(service, errorCounter);
    }

    protected void readBlockUpdateListAndCache(int blockNumber, DatasetReader reader, NormalizationType no, List<Block> blockList, String key, AtomicInteger errorCounter, ExecutorService service, BlockModifier modifier) {
        Runnable loader = () -> {
            try {
                Block b = reader.readNormalizedBlock(blockNumber, this, no);
                if (b == null) {
                    b = new Block(blockNumber, key);
                }
                b = modifier.modify(b, key, this.getBinSize(), this.getChr1(), this.getChr2());
                if (this.useCache) {
                    this.blockCache.put(key, b);
                }
                blockList.add(b);
            }
            catch (IOException e) {
                errorCounter.incrementAndGet();
            }
        };
        service.submit(loader);
    }

    public String getDescription() {
        return this.chr1.getName() + " - " + this.chr2.getName() + " - " + this.getZoom();
    }

    public void printFullDescription() {
        System.out.println("Chromosomes: " + this.chr1.getName() + " - " + this.chr2.getName());
        System.out.println("unit: " + (Object)((Object)this.zoom.getUnit()));
        System.out.println("binSize (bp): " + this.zoom.getBinSize());
        System.out.println("blockBinCount (bins): " + this.blockBinCount);
        System.out.println("blockColumnCount (columns): " + this.blockColumnCount);
        System.out.println("Block size (bp): " + this.blockBinCount * this.zoom.getBinSize());
        System.out.println();
    }

    protected List<Integer> getBlockNumbersForRegionFromGenomePosition(long[] regionIndices) {
        int resolution = this.zoom.getBinSize();
        long[] regionBinIndices = new long[4];
        for (int i = 0; i < regionBinIndices.length; ++i) {
            regionBinIndices[i] = regionIndices[i] / (long)resolution;
        }
        return this.getBlockNumbersForRegionFromBinPosition(regionBinIndices);
    }

    protected List<Integer> getBlockNumbersForRegionFromBinPosition(long[] regionIndices) {
        int blockNumber;
        int c;
        int r;
        int col1 = (int)(regionIndices[0] / (long)this.blockBinCount);
        int col2 = (int)((regionIndices[1] + 1L) / (long)this.blockBinCount);
        int row1 = (int)(regionIndices[2] / (long)this.blockBinCount);
        int row2 = (int)((regionIndices[3] + 1L) / (long)this.blockBinCount);
        HashSet<Integer> blocksSet = new HashSet<Integer>();
        for (r = row1; r <= row2; ++r) {
            for (c = col1; c <= col2; ++c) {
                blockNumber = r * this.getBlockColumnCount() + c;
                blocksSet.add(blockNumber);
            }
        }
        if (this.chr1.getIndex() == this.chr2.getIndex()) {
            for (r = col1; r <= col2; ++r) {
                for (c = row1; c <= row2; ++c) {
                    blockNumber = r * this.getBlockColumnCount() + c;
                    blocksSet.add(blockNumber);
                }
            }
        }
        ArrayList<Integer> blocksToIterateOver = new ArrayList<Integer>(blocksSet);
        Collections.sort(blocksToIterateOver);
        return blocksToIterateOver;
    }

    public double getAverageCount() {
        return this.averageCount;
    }

    public void setAverageCount(double averageCount) {
        this.averageCount = averageCount;
    }

    public void clearCache() {
        this.blockCache.clear();
        this.pearsonsMap.clear();
        this.eigenvectorMap.clear();
    }

    public long getNumberOfContactRecords() {
        return this.getIteratorContainer().getNumberOfContactRecords();
    }

    protected Iterator<ContactRecord> getNewContactRecordIterator() {
        return this.getIteratorContainer().getNewContactRecordIterator();
    }

    public IteratorContainer getIteratorContainer() {
        if (this.iteratorContainer == null) {
            this.iteratorContainer = ListOfListGenerator.createFromZD(this.reader, this, this.blockCache, this.useCache, useIteratorDontPutAllInRAM, shouldCheckRAMUsage);
        }
        return this.iteratorContainer;
    }

    public IteratorContainer getFromFileIteratorContainer() {
        return new ZDIteratorContainer(this.reader, this, this.blockCache, this.useCache);
    }

    public BasicMatrix getPearsons(ExpectedValueFunction df) {
        if (this.chr1.getIndex() != this.chr2.getIndex()) {
            throw new RuntimeException("Cannot compute pearsons for non-diagonal matrices");
        }
        BasicMatrix pearsons = this.pearsonsMap.get(df.getNormalizationType());
        if (pearsons != null) {
            return pearsons;
        }
        pearsons = PearsonsManager.computePearsons(df, this.getNewContactRecordIterator(), this.chr1, this.zoom.getBinSize());
        this.pearsonsMap.put(df.getNormalizationType(), pearsons);
        return this.pearsonsMap.get(df.getNormalizationType());
    }

    protected BasicMatrix getPearsons(NormalizationType type) {
        return this.pearsonsMap.get(type);
    }

    public float getPearsonValue(int binX, int binY, NormalizationType type) {
        BasicMatrix pearsons = this.pearsonsMap.get(type);
        if (pearsons != null) {
            return pearsons.getEntry(binX, binY);
        }
        return 0.0f;
    }

    public double[] getEigenvector(ExpectedValueFunction df, int which) {
        if (this.chr1.getIndex() != this.chr2.getIndex()) {
            throw new RuntimeException("Cannot compute eigenvector for non-diagonal matrices");
        }
        String eigKey = this.getEigenvectorKey(df.getNormalizationType(), which);
        double[] eig = this.eigenvectorMap.get(eigKey);
        if (eig != null) {
            return eig;
        }
        BasicMatrix pearsons = this.getPearsons(df);
        if (pearsons == null) {
            return null;
        }
        eig = PearsonsManager.computeEigenvector(pearsons, which);
        this.eigenvectorMap.put(eigKey, eig);
        return this.eigenvectorMap.get(eigKey);
    }

    protected String getEigenvectorKey(NormalizationType normalizationType, int which) {
        return normalizationType.getLabel() + "_" + which;
    }

    protected double[] getEigenvector(NormalizationType normalizationType, int which) {
        return this.eigenvectorMap.get(this.getEigenvectorKey(normalizationType, which));
    }
}

